package zio.aws.paymentcryptography.model
import scala.jdk.CollectionConverters.*
sealed trait KeyCheckValueAlgorithm {
  def unwrap: software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm
}
object KeyCheckValueAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm
  ): zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm = value match {
    case software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm.CMAC =>
      val r = CMAC
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm.ANSI_X9_24 =>
      val r = ANSI_X9_24
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm =
      software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object CMAC
      extends zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm =
      software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm.CMAC
  }
  case object ANSI_X9_24
      extends zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm =
      software.amazon.awssdk.services.paymentcryptography.model.KeyCheckValueAlgorithm.ANSI_X9_24
  }
}
