package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.KeyArnOrKeyAliasType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ExportTr31KeyBlock(
    wrappingKeyIdentifier: KeyArnOrKeyAliasType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ExportTr31KeyBlock = {
    import ExportTr31KeyBlock.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ExportTr31KeyBlock
      .builder()
      .wrappingKeyIdentifier(
        KeyArnOrKeyAliasType.unwrap(wrappingKeyIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.ExportTr31KeyBlock.ReadOnly =
    zio.aws.paymentcryptography.model.ExportTr31KeyBlock.wrap(buildAwsValue())
}
object ExportTr31KeyBlock {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ExportTr31KeyBlock
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.ExportTr31KeyBlock =
      zio.aws.paymentcryptography.model
        .ExportTr31KeyBlock(wrappingKeyIdentifier)
    def wrappingKeyIdentifier: KeyArnOrKeyAliasType
    def getWrappingKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(wrappingKeyIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ExportTr31KeyBlock
  ) extends zio.aws.paymentcryptography.model.ExportTr31KeyBlock.ReadOnly {
    override val wrappingKeyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptography.model.primitives
        .KeyArnOrKeyAliasType(impl.wrappingKeyIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ExportTr31KeyBlock
  ): zio.aws.paymentcryptography.model.ExportTr31KeyBlock.ReadOnly =
    new Wrapper(impl)
}
