package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.KeyArnOrKeyAliasType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class StartKeyUsageRequest(keyIdentifier: KeyArnOrKeyAliasType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.StartKeyUsageRequest = {
    import StartKeyUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.StartKeyUsageRequest
      .builder()
      .keyIdentifier(
        KeyArnOrKeyAliasType.unwrap(keyIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.StartKeyUsageRequest.ReadOnly =
    zio.aws.paymentcryptography.model.StartKeyUsageRequest.wrap(buildAwsValue())
}
object StartKeyUsageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.StartKeyUsageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.StartKeyUsageRequest =
      zio.aws.paymentcryptography.model.StartKeyUsageRequest(keyIdentifier)
    def keyIdentifier: KeyArnOrKeyAliasType
    def getKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(keyIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.StartKeyUsageRequest
  ) extends zio.aws.paymentcryptography.model.StartKeyUsageRequest.ReadOnly {
    override val keyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptography.model.primitives
        .KeyArnOrKeyAliasType(impl.keyIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.StartKeyUsageRequest
  ): zio.aws.paymentcryptography.model.StartKeyUsageRequest.ReadOnly =
    new Wrapper(impl)
}
