package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    tags: Iterable[zio.aws.paymentcryptography.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.paymentcryptography.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptography.model.ListTagsForResourceResponse =
      zio.aws.paymentcryptography.model.ListTagsForResourceResponse(
        nextToken.map(value => value),
        tags.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def tags: List[zio.aws.paymentcryptography.model.Tag.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.paymentcryptography.model.Tag.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ListTagsForResourceResponse
  ) extends zio.aws.paymentcryptography.model.ListTagsForResourceResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.NextToken(value)
      )
    override val tags: List[zio.aws.paymentcryptography.model.Tag.ReadOnly] =
      impl
        .tags()
        .asScala
        .map { item =>
          zio.aws.paymentcryptography.model.Tag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ListTagsForResourceResponse
  ): zio.aws.paymentcryptography.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
