package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.{KeyCheckValue, KeyArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KeySummary(
    enabled: Boolean,
    exportable: Boolean,
    keyArn: KeyArn,
    keyAttributes: zio.aws.paymentcryptography.model.KeyAttributes,
    keyCheckValue: KeyCheckValue,
    keyState: zio.aws.paymentcryptography.model.KeyState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.KeySummary = {
    import KeySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.KeySummary
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .exportable(exportable: java.lang.Boolean)
      .keyArn(KeyArn.unwrap(keyArn): java.lang.String)
      .keyAttributes(keyAttributes.buildAwsValue())
      .keyCheckValue(KeyCheckValue.unwrap(keyCheckValue): java.lang.String)
      .keyState(keyState.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.KeySummary.ReadOnly =
    zio.aws.paymentcryptography.model.KeySummary.wrap(buildAwsValue())
}
object KeySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.KeySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.KeySummary =
      zio.aws.paymentcryptography.model.KeySummary(
        enabled,
        exportable,
        keyArn,
        keyAttributes.asEditable,
        keyCheckValue,
        keyState
      )
    def enabled: Boolean
    def exportable: Boolean
    def keyArn: KeyArn
    def keyAttributes: zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly
    def keyCheckValue: KeyCheckValue
    def keyState: zio.aws.paymentcryptography.model.KeyState
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getExportable: ZIO[Any, Nothing, Boolean] = ZIO.succeed(exportable)
    def getKeyArn: ZIO[Any, Nothing, KeyArn] = ZIO.succeed(keyArn)
    def getKeyAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly
    ] = ZIO.succeed(keyAttributes)
    def getKeyCheckValue: ZIO[Any, Nothing, KeyCheckValue] =
      ZIO.succeed(keyCheckValue)
    def getKeyState
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.KeyState] =
      ZIO.succeed(keyState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.KeySummary
  ) extends zio.aws.paymentcryptography.model.KeySummary.ReadOnly {
    override val enabled: Boolean = impl.enabled(): Boolean
    override val exportable: Boolean = impl.exportable(): Boolean
    override val keyArn: KeyArn =
      zio.aws.paymentcryptography.model.primitives.KeyArn(impl.keyArn())
    override val keyAttributes
        : zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly =
      zio.aws.paymentcryptography.model.KeyAttributes.wrap(impl.keyAttributes())
    override val keyCheckValue: KeyCheckValue =
      zio.aws.paymentcryptography.model.primitives
        .KeyCheckValue(impl.keyCheckValue())
    override val keyState: zio.aws.paymentcryptography.model.KeyState =
      zio.aws.paymentcryptography.model.KeyState.wrap(impl.keyState())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.KeySummary
  ): zio.aws.paymentcryptography.model.KeySummary.ReadOnly = new Wrapper(impl)
}
