package zio.aws.paymentcryptography.model
import scala.jdk.CollectionConverters.*
sealed trait KeyState {
  def unwrap: software.amazon.awssdk.services.paymentcryptography.model.KeyState
}
object KeyState {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptography.model.KeyState
  ): zio.aws.paymentcryptography.model.KeyState = value match {
    case software.amazon.awssdk.services.paymentcryptography.model.KeyState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyState.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyState.CREATE_COMPLETE =>
      val r = CREATE_COMPLETE
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyState.DELETE_PENDING =>
      val r = DELETE_PENDING
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyState.DELETE_COMPLETE =>
      val r = DELETE_COMPLETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptography.model.KeyState {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyState =
      software.amazon.awssdk.services.paymentcryptography.model.KeyState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_IN_PROGRESS
      extends zio.aws.paymentcryptography.model.KeyState {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyState =
      software.amazon.awssdk.services.paymentcryptography.model.KeyState.CREATE_IN_PROGRESS
  }
  case object CREATE_COMPLETE
      extends zio.aws.paymentcryptography.model.KeyState {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyState =
      software.amazon.awssdk.services.paymentcryptography.model.KeyState.CREATE_COMPLETE
  }
  case object DELETE_PENDING
      extends zio.aws.paymentcryptography.model.KeyState {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyState =
      software.amazon.awssdk.services.paymentcryptography.model.KeyState.DELETE_PENDING
  }
  case object DELETE_COMPLETE
      extends zio.aws.paymentcryptography.model.KeyState {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyState =
      software.amazon.awssdk.services.paymentcryptography.model.KeyState.DELETE_COMPLETE
  }
}
