package zio.aws.paymentcryptography.model
import scala.jdk.CollectionConverters.*
sealed trait KeyMaterialType {
  def unwrap: software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType
}
object KeyMaterialType {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType
  ): zio.aws.paymentcryptography.model.KeyMaterialType = value match {
    case software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType.TR34_KEY_BLOCK =>
      val r = TR34_KEY_BLOCK
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType.TR31_KEY_BLOCK =>
      val r = TR31_KEY_BLOCK
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType.ROOT_PUBLIC_KEY_CERTIFICATE =>
      val r = ROOT_PUBLIC_KEY_CERTIFICATE
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType.TRUSTED_PUBLIC_KEY_CERTIFICATE =>
      val r = TRUSTED_PUBLIC_KEY_CERTIFICATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptography.model.KeyMaterialType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType =
      software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType.UNKNOWN_TO_SDK_VERSION
  }
  case object TR34_KEY_BLOCK
      extends zio.aws.paymentcryptography.model.KeyMaterialType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType =
      software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType.TR34_KEY_BLOCK
  }
  case object TR31_KEY_BLOCK
      extends zio.aws.paymentcryptography.model.KeyMaterialType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType =
      software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType.TR31_KEY_BLOCK
  }
  case object ROOT_PUBLIC_KEY_CERTIFICATE
      extends zio.aws.paymentcryptography.model.KeyMaterialType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType =
      software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType.ROOT_PUBLIC_KEY_CERTIFICATE
  }
  case object TRUSTED_PUBLIC_KEY_CERTIFICATE
      extends zio.aws.paymentcryptography.model.KeyMaterialType {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType =
      software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType.TRUSTED_PUBLIC_KEY_CERTIFICATE
  }
}
