package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KeyAttributes(
    keyAlgorithm: zio.aws.paymentcryptography.model.KeyAlgorithm,
    keyClass: zio.aws.paymentcryptography.model.KeyClass,
    keyModesOfUse: zio.aws.paymentcryptography.model.KeyModesOfUse,
    keyUsage: zio.aws.paymentcryptography.model.KeyUsage
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.KeyAttributes = {
    import KeyAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.KeyAttributes
      .builder()
      .keyAlgorithm(keyAlgorithm.unwrap)
      .keyClass(keyClass.unwrap)
      .keyModesOfUse(keyModesOfUse.buildAwsValue())
      .keyUsage(keyUsage.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly =
    zio.aws.paymentcryptography.model.KeyAttributes.wrap(buildAwsValue())
}
object KeyAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.KeyAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.KeyAttributes =
      zio.aws.paymentcryptography.model.KeyAttributes(
        keyAlgorithm,
        keyClass,
        keyModesOfUse.asEditable,
        keyUsage
      )
    def keyAlgorithm: zio.aws.paymentcryptography.model.KeyAlgorithm
    def keyClass: zio.aws.paymentcryptography.model.KeyClass
    def keyModesOfUse: zio.aws.paymentcryptography.model.KeyModesOfUse.ReadOnly
    def keyUsage: zio.aws.paymentcryptography.model.KeyUsage
    def getKeyAlgorithm
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.KeyAlgorithm] =
      ZIO.succeed(keyAlgorithm)
    def getKeyClass
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.KeyClass] =
      ZIO.succeed(keyClass)
    def getKeyModesOfUse: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptography.model.KeyModesOfUse.ReadOnly
    ] = ZIO.succeed(keyModesOfUse)
    def getKeyUsage
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.KeyUsage] =
      ZIO.succeed(keyUsage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.KeyAttributes
  ) extends zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly {
    override val keyAlgorithm: zio.aws.paymentcryptography.model.KeyAlgorithm =
      zio.aws.paymentcryptography.model.KeyAlgorithm.wrap(impl.keyAlgorithm())
    override val keyClass: zio.aws.paymentcryptography.model.KeyClass =
      zio.aws.paymentcryptography.model.KeyClass.wrap(impl.keyClass())
    override val keyModesOfUse
        : zio.aws.paymentcryptography.model.KeyModesOfUse.ReadOnly =
      zio.aws.paymentcryptography.model.KeyModesOfUse.wrap(impl.keyModesOfUse())
    override val keyUsage: zio.aws.paymentcryptography.model.KeyUsage =
      zio.aws.paymentcryptography.model.KeyUsage.wrap(impl.keyUsage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.KeyAttributes
  ): zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly = new Wrapper(
    impl
  )
}
