package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.{
  CertificateType,
  Tr34WrappedKeyBlock,
  ImportTokenId,
  HexLength16,
  KeyArnOrKeyAliasType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportTr34KeyBlock(
    certificateAuthorityPublicKeyIdentifier: KeyArnOrKeyAliasType,
    importToken: ImportTokenId,
    keyBlockFormat: zio.aws.paymentcryptography.model.Tr34KeyBlockFormat,
    randomNonce: Optional[HexLength16] = Optional.Absent,
    signingKeyCertificate: CertificateType,
    wrappedKeyBlock: Tr34WrappedKeyBlock
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ImportTr34KeyBlock = {
    import ImportTr34KeyBlock.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ImportTr34KeyBlock
      .builder()
      .certificateAuthorityPublicKeyIdentifier(
        KeyArnOrKeyAliasType.unwrap(
          certificateAuthorityPublicKeyIdentifier
        ): java.lang.String
      )
      .importToken(ImportTokenId.unwrap(importToken): java.lang.String)
      .keyBlockFormat(keyBlockFormat.unwrap)
      .optionallyWith(
        randomNonce.map(value => HexLength16.unwrap(value): java.lang.String)
      )(_.randomNonce)
      .signingKeyCertificate(
        CertificateType.unwrap(signingKeyCertificate): java.lang.String
      )
      .wrappedKeyBlock(
        Tr34WrappedKeyBlock.unwrap(wrappedKeyBlock): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.ImportTr34KeyBlock.ReadOnly =
    zio.aws.paymentcryptography.model.ImportTr34KeyBlock.wrap(buildAwsValue())
}
object ImportTr34KeyBlock {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ImportTr34KeyBlock
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.ImportTr34KeyBlock =
      zio.aws.paymentcryptography.model.ImportTr34KeyBlock(
        certificateAuthorityPublicKeyIdentifier,
        importToken,
        keyBlockFormat,
        randomNonce.map(value => value),
        signingKeyCertificate,
        wrappedKeyBlock
      )
    def certificateAuthorityPublicKeyIdentifier: KeyArnOrKeyAliasType
    def importToken: ImportTokenId
    def keyBlockFormat: zio.aws.paymentcryptography.model.Tr34KeyBlockFormat
    def randomNonce: Optional[HexLength16]
    def signingKeyCertificate: CertificateType
    def wrappedKeyBlock: Tr34WrappedKeyBlock
    def getCertificateAuthorityPublicKeyIdentifier
        : ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(certificateAuthorityPublicKeyIdentifier)
    def getImportToken: ZIO[Any, Nothing, ImportTokenId] =
      ZIO.succeed(importToken)
    def getKeyBlockFormat: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptography.model.Tr34KeyBlockFormat
    ] = ZIO.succeed(keyBlockFormat)
    def getRandomNonce: ZIO[Any, AwsError, HexLength16] =
      AwsError.unwrapOptionField("randomNonce", randomNonce)
    def getSigningKeyCertificate: ZIO[Any, Nothing, CertificateType] =
      ZIO.succeed(signingKeyCertificate)
    def getWrappedKeyBlock: ZIO[Any, Nothing, Tr34WrappedKeyBlock] =
      ZIO.succeed(wrappedKeyBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ImportTr34KeyBlock
  ) extends zio.aws.paymentcryptography.model.ImportTr34KeyBlock.ReadOnly {
    override val certificateAuthorityPublicKeyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptography.model.primitives
        .KeyArnOrKeyAliasType(impl.certificateAuthorityPublicKeyIdentifier())
    override val importToken: ImportTokenId =
      zio.aws.paymentcryptography.model.primitives
        .ImportTokenId(impl.importToken())
    override val keyBlockFormat
        : zio.aws.paymentcryptography.model.Tr34KeyBlockFormat =
      zio.aws.paymentcryptography.model.Tr34KeyBlockFormat
        .wrap(impl.keyBlockFormat())
    override val randomNonce: Optional[HexLength16] = zio.aws.core.internal
      .optionalFromNullable(impl.randomNonce())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.HexLength16(value)
      )
    override val signingKeyCertificate: CertificateType =
      zio.aws.paymentcryptography.model.primitives
        .CertificateType(impl.signingKeyCertificate())
    override val wrappedKeyBlock: Tr34WrappedKeyBlock =
      zio.aws.paymentcryptography.model.primitives
        .Tr34WrappedKeyBlock(impl.wrappedKeyBlock())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ImportTr34KeyBlock
  ): zio.aws.paymentcryptography.model.ImportTr34KeyBlock.ReadOnly =
    new Wrapper(impl)
}
