package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ImportKeyResponse(key: zio.aws.paymentcryptography.model.Key) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ImportKeyResponse = {
    import ImportKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ImportKeyResponse
      .builder()
      .key(key.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.ImportKeyResponse.ReadOnly =
    zio.aws.paymentcryptography.model.ImportKeyResponse.wrap(buildAwsValue())
}
object ImportKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ImportKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.ImportKeyResponse =
      zio.aws.paymentcryptography.model.ImportKeyResponse(key.asEditable)
    def key: zio.aws.paymentcryptography.model.Key.ReadOnly
    def getKey
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.Key.ReadOnly] =
      ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ImportKeyResponse
  ) extends zio.aws.paymentcryptography.model.ImportKeyResponse.ReadOnly {
    override val key: zio.aws.paymentcryptography.model.Key.ReadOnly =
      zio.aws.paymentcryptography.model.Key.wrap(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ImportKeyResponse
  ): zio.aws.paymentcryptography.model.ImportKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
