package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.CertificateType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetPublicKeyCertificateResponse(
    keyCertificate: CertificateType,
    keyCertificateChain: CertificateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.GetPublicKeyCertificateResponse = {
    import GetPublicKeyCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.GetPublicKeyCertificateResponse
      .builder()
      .keyCertificate(CertificateType.unwrap(keyCertificate): java.lang.String)
      .keyCertificateChain(
        CertificateType.unwrap(keyCertificateChain): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.GetPublicKeyCertificateResponse.ReadOnly =
    zio.aws.paymentcryptography.model.GetPublicKeyCertificateResponse
      .wrap(buildAwsValue())
}
object GetPublicKeyCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.GetPublicKeyCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptography.model.GetPublicKeyCertificateResponse =
      zio.aws.paymentcryptography.model
        .GetPublicKeyCertificateResponse(keyCertificate, keyCertificateChain)
    def keyCertificate: CertificateType
    def keyCertificateChain: CertificateType
    def getKeyCertificate: ZIO[Any, Nothing, CertificateType] =
      ZIO.succeed(keyCertificate)
    def getKeyCertificateChain: ZIO[Any, Nothing, CertificateType] =
      ZIO.succeed(keyCertificateChain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetPublicKeyCertificateResponse
  ) extends zio.aws.paymentcryptography.model.GetPublicKeyCertificateResponse.ReadOnly {
    override val keyCertificate: CertificateType =
      zio.aws.paymentcryptography.model.primitives
        .CertificateType(impl.keyCertificate())
    override val keyCertificateChain: CertificateType =
      zio.aws.paymentcryptography.model.primitives
        .CertificateType(impl.keyCertificateChain())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetPublicKeyCertificateResponse
  ): zio.aws.paymentcryptography.model.GetPublicKeyCertificateResponse.ReadOnly =
    new Wrapper(impl)
}
