package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.KeyArnOrKeyAliasType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetPublicKeyCertificateRequest(
    keyIdentifier: KeyArnOrKeyAliasType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.GetPublicKeyCertificateRequest = {
    import GetPublicKeyCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.GetPublicKeyCertificateRequest
      .builder()
      .keyIdentifier(
        KeyArnOrKeyAliasType.unwrap(keyIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.GetPublicKeyCertificateRequest.ReadOnly =
    zio.aws.paymentcryptography.model.GetPublicKeyCertificateRequest
      .wrap(buildAwsValue())
}
object GetPublicKeyCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.GetPublicKeyCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptography.model.GetPublicKeyCertificateRequest =
      zio.aws.paymentcryptography.model
        .GetPublicKeyCertificateRequest(keyIdentifier)
    def keyIdentifier: KeyArnOrKeyAliasType
    def getKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(keyIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetPublicKeyCertificateRequest
  ) extends zio.aws.paymentcryptography.model.GetPublicKeyCertificateRequest.ReadOnly {
    override val keyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptography.model.primitives
        .KeyArnOrKeyAliasType(impl.keyIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetPublicKeyCertificateRequest
  ): zio.aws.paymentcryptography.model.GetPublicKeyCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
