package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetKeyResponse(key: zio.aws.paymentcryptography.model.Key) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.GetKeyResponse = {
    import GetKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.GetKeyResponse
      .builder()
      .key(key.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.GetKeyResponse.ReadOnly =
    zio.aws.paymentcryptography.model.GetKeyResponse.wrap(buildAwsValue())
}
object GetKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.GetKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.GetKeyResponse =
      zio.aws.paymentcryptography.model.GetKeyResponse(key.asEditable)
    def key: zio.aws.paymentcryptography.model.Key.ReadOnly
    def getKey
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.Key.ReadOnly] =
      ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetKeyResponse
  ) extends zio.aws.paymentcryptography.model.GetKeyResponse.ReadOnly {
    override val key: zio.aws.paymentcryptography.model.Key.ReadOnly =
      zio.aws.paymentcryptography.model.Key.wrap(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetKeyResponse
  ): zio.aws.paymentcryptography.model.GetKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
