package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.{
  CertificateType,
  HexLength16,
  ExportTokenId,
  KeyArnOrKeyAliasType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExportTr34KeyBlock(
    certificateAuthorityPublicKeyIdentifier: KeyArnOrKeyAliasType,
    exportToken: ExportTokenId,
    keyBlockFormat: zio.aws.paymentcryptography.model.Tr34KeyBlockFormat,
    randomNonce: Optional[HexLength16] = Optional.Absent,
    wrappingKeyCertificate: CertificateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ExportTr34KeyBlock = {
    import ExportTr34KeyBlock.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ExportTr34KeyBlock
      .builder()
      .certificateAuthorityPublicKeyIdentifier(
        KeyArnOrKeyAliasType.unwrap(
          certificateAuthorityPublicKeyIdentifier
        ): java.lang.String
      )
      .exportToken(ExportTokenId.unwrap(exportToken): java.lang.String)
      .keyBlockFormat(keyBlockFormat.unwrap)
      .optionallyWith(
        randomNonce.map(value => HexLength16.unwrap(value): java.lang.String)
      )(_.randomNonce)
      .wrappingKeyCertificate(
        CertificateType.unwrap(wrappingKeyCertificate): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.ExportTr34KeyBlock.ReadOnly =
    zio.aws.paymentcryptography.model.ExportTr34KeyBlock.wrap(buildAwsValue())
}
object ExportTr34KeyBlock {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ExportTr34KeyBlock
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.ExportTr34KeyBlock =
      zio.aws.paymentcryptography.model.ExportTr34KeyBlock(
        certificateAuthorityPublicKeyIdentifier,
        exportToken,
        keyBlockFormat,
        randomNonce.map(value => value),
        wrappingKeyCertificate
      )
    def certificateAuthorityPublicKeyIdentifier: KeyArnOrKeyAliasType
    def exportToken: ExportTokenId
    def keyBlockFormat: zio.aws.paymentcryptography.model.Tr34KeyBlockFormat
    def randomNonce: Optional[HexLength16]
    def wrappingKeyCertificate: CertificateType
    def getCertificateAuthorityPublicKeyIdentifier
        : ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(certificateAuthorityPublicKeyIdentifier)
    def getExportToken: ZIO[Any, Nothing, ExportTokenId] =
      ZIO.succeed(exportToken)
    def getKeyBlockFormat: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptography.model.Tr34KeyBlockFormat
    ] = ZIO.succeed(keyBlockFormat)
    def getRandomNonce: ZIO[Any, AwsError, HexLength16] =
      AwsError.unwrapOptionField("randomNonce", randomNonce)
    def getWrappingKeyCertificate: ZIO[Any, Nothing, CertificateType] =
      ZIO.succeed(wrappingKeyCertificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ExportTr34KeyBlock
  ) extends zio.aws.paymentcryptography.model.ExportTr34KeyBlock.ReadOnly {
    override val certificateAuthorityPublicKeyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptography.model.primitives
        .KeyArnOrKeyAliasType(impl.certificateAuthorityPublicKeyIdentifier())
    override val exportToken: ExportTokenId =
      zio.aws.paymentcryptography.model.primitives
        .ExportTokenId(impl.exportToken())
    override val keyBlockFormat
        : zio.aws.paymentcryptography.model.Tr34KeyBlockFormat =
      zio.aws.paymentcryptography.model.Tr34KeyBlockFormat
        .wrap(impl.keyBlockFormat())
    override val randomNonce: Optional[HexLength16] = zio.aws.core.internal
      .optionalFromNullable(impl.randomNonce())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.HexLength16(value)
      )
    override val wrappingKeyCertificate: CertificateType =
      zio.aws.paymentcryptography.model.primitives
        .CertificateType(impl.wrappingKeyCertificate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ExportTr34KeyBlock
  ): zio.aws.paymentcryptography.model.ExportTr34KeyBlock.ReadOnly =
    new Wrapper(impl)
}
