package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.AliasName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAliasRequest(aliasName: AliasName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.DeleteAliasRequest = {
    import DeleteAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.DeleteAliasRequest
      .builder()
      .aliasName(AliasName.unwrap(aliasName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.DeleteAliasRequest.ReadOnly =
    zio.aws.paymentcryptography.model.DeleteAliasRequest.wrap(buildAwsValue())
}
object DeleteAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.DeleteAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.DeleteAliasRequest =
      zio.aws.paymentcryptography.model.DeleteAliasRequest(aliasName)
    def aliasName: AliasName
    def getAliasName: ZIO[Any, Nothing, AliasName] = ZIO.succeed(aliasName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.DeleteAliasRequest
  ) extends zio.aws.paymentcryptography.model.DeleteAliasRequest.ReadOnly {
    override val aliasName: AliasName =
      zio.aws.paymentcryptography.model.primitives.AliasName(impl.aliasName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.DeleteAliasRequest
  ): zio.aws.paymentcryptography.model.DeleteAliasRequest.ReadOnly =
    new Wrapper(impl)
}
