package zio.aws.paymentcryptography
import zio.aws.paymentcryptography.model.ListKeysResponse.ReadOnly
import zio.aws.paymentcryptography.model.{
  GetParametersForImportRequest,
  UpdateAliasRequest,
  GetKeyRequest,
  CreateKeyRequest,
  CreateAliasRequest,
  ListTagsForResourceRequest,
  DeleteAliasRequest,
  ListAliasesRequest,
  DeleteKeyRequest,
  RestoreKeyRequest,
  ImportKeyRequest,
  GetPublicKeyCertificateRequest,
  UntagResourceRequest,
  StopKeyUsageRequest,
  StartKeyUsageRequest,
  ListKeysRequest,
  ExportKeyRequest,
  TagResourceRequest,
  GetAliasRequest,
  GetParametersForExportRequest
}
import software.amazon.awssdk.services.paymentcryptography.model.{
  UpdateAliasResponse,
  ListKeysResponse,
  ExportKeyResponse,
  ImportKeyResponse,
  DeleteAliasResponse,
  Tag,
  CreateAliasResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeleteKeyResponse,
  GetAliasResponse,
  GetPublicKeyCertificateResponse,
  GetParametersForImportResponse,
  StartKeyUsageResponse,
  StopKeyUsageResponse,
  RestoreKeyResponse,
  CreateKeyResponse,
  GetParametersForExportResponse,
  ListAliasesResponse,
  KeySummary,
  TagResourceResponse,
  GetKeyResponse,
  Alias
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.paymentcryptography.{
  PaymentCryptographyAsyncClientBuilder,
  PaymentCryptographyAsyncClient
}
import scala.jdk.CollectionConverters.*
trait PaymentCryptography extends AspectSupport[PaymentCryptography] {
  val api: PaymentCryptographyAsyncClient
  def getKey(
      request: GetKeyRequest
  ): IO[AwsError, zio.aws.paymentcryptography.model.GetKeyResponse.ReadOnly]
  def exportKey(
      request: ExportKeyRequest
  ): IO[AwsError, zio.aws.paymentcryptography.model.ExportKeyResponse.ReadOnly]
  def deleteKey(
      request: DeleteKeyRequest
  ): IO[AwsError, zio.aws.paymentcryptography.model.DeleteKeyResponse.ReadOnly]
  def getParametersForExport(request: GetParametersForExportRequest): IO[
    AwsError,
    zio.aws.paymentcryptography.model.GetParametersForExportResponse.ReadOnly
  ]
  def stopKeyUsage(request: StopKeyUsageRequest): IO[
    AwsError,
    zio.aws.paymentcryptography.model.StopKeyUsageResponse.ReadOnly
  ]
  def listAliases(
      request: ListAliasesRequest
  ): ZStream[Any, AwsError, zio.aws.paymentcryptography.model.Alias.ReadOnly]
  def listAliasesPaginated(request: ListAliasesRequest): IO[
    AwsError,
    zio.aws.paymentcryptography.model.ListAliasesResponse.ReadOnly
  ]
  def getParametersForImport(request: GetParametersForImportRequest): IO[
    AwsError,
    zio.aws.paymentcryptography.model.GetParametersForImportResponse.ReadOnly
  ]
  def restoreKey(
      request: RestoreKeyRequest
  ): IO[AwsError, zio.aws.paymentcryptography.model.RestoreKeyResponse.ReadOnly]
  def updateAlias(request: UpdateAliasRequest): IO[
    AwsError,
    zio.aws.paymentcryptography.model.UpdateAliasResponse.ReadOnly
  ]
  def untagResource(request: UntagResourceRequest): IO[
    AwsError,
    zio.aws.paymentcryptography.model.UntagResourceResponse.ReadOnly
  ]
  def createAlias(request: CreateAliasRequest): IO[
    AwsError,
    zio.aws.paymentcryptography.model.CreateAliasResponse.ReadOnly
  ]
  def getPublicKeyCertificate(request: GetPublicKeyCertificateRequest): IO[
    AwsError,
    zio.aws.paymentcryptography.model.GetPublicKeyCertificateResponse.ReadOnly
  ]
  def createKey(
      request: CreateKeyRequest
  ): IO[AwsError, zio.aws.paymentcryptography.model.CreateKeyResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.paymentcryptography.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.paymentcryptography.model.ListTagsForResourceResponse.ReadOnly
  ]
  def startKeyUsage(request: StartKeyUsageRequest): IO[
    AwsError,
    zio.aws.paymentcryptography.model.StartKeyUsageResponse.ReadOnly
  ]
  def tagResource(request: TagResourceRequest): IO[
    AwsError,
    zio.aws.paymentcryptography.model.TagResourceResponse.ReadOnly
  ]
  def importKey(
      request: ImportKeyRequest
  ): IO[AwsError, zio.aws.paymentcryptography.model.ImportKeyResponse.ReadOnly]
  def deleteAlias(request: DeleteAliasRequest): IO[
    AwsError,
    zio.aws.paymentcryptography.model.DeleteAliasResponse.ReadOnly
  ]
  def getAlias(
      request: GetAliasRequest
  ): IO[AwsError, zio.aws.paymentcryptography.model.GetAliasResponse.ReadOnly]
  def listKeys(request: ListKeysRequest): ZStream[
    Any,
    AwsError,
    zio.aws.paymentcryptography.model.KeySummary.ReadOnly
  ]
  def listKeysPaginated(request: ListKeysRequest): IO[AwsError, ReadOnly]
}
object PaymentCryptography {
  val live: ZLayer[AwsConfig, java.lang.Throwable, PaymentCryptography] =
    customized(identity)
  def customized(
      customization: PaymentCryptographyAsyncClientBuilder => PaymentCryptographyAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, PaymentCryptography] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: PaymentCryptographyAsyncClientBuilder => PaymentCryptographyAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, PaymentCryptography] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = PaymentCryptographyAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      PaymentCryptographyAsyncClient,
      PaymentCryptographyAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      PaymentCryptographyAsyncClient,
      PaymentCryptographyAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new PaymentCryptographyImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class PaymentCryptographyImpl[R](
      override val api: PaymentCryptographyAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends PaymentCryptography
      with AwsServiceBase[R] {
    override val serviceName: String = "PaymentCryptography"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PaymentCryptographyImpl[R1] =
      new PaymentCryptographyImpl(api, newAspect, r)
    def getKey(
        request: GetKeyRequest
    ): IO[AwsError, zio.aws.paymentcryptography.model.GetKeyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.paymentcryptography.model.GetKeyRequest,
        GetKeyResponse
      ]("getKey", api.getKey)(request.buildAwsValue())
        .map(zio.aws.paymentcryptography.model.GetKeyResponse.wrap)
        .provideEnvironment(r)
    def exportKey(request: ExportKeyRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.ExportKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.ExportKeyRequest,
      ExportKeyResponse
    ]("exportKey", api.exportKey)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.ExportKeyResponse.wrap)
      .provideEnvironment(r)
    def deleteKey(request: DeleteKeyRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.DeleteKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.DeleteKeyRequest,
      DeleteKeyResponse
    ]("deleteKey", api.deleteKey)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.DeleteKeyResponse.wrap)
      .provideEnvironment(r)
    def getParametersForExport(request: GetParametersForExportRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.GetParametersForExportResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.GetParametersForExportRequest,
      GetParametersForExportResponse
    ]("getParametersForExport", api.getParametersForExport)(
      request.buildAwsValue()
    ).map(zio.aws.paymentcryptography.model.GetParametersForExportResponse.wrap)
      .provideEnvironment(r)
    def stopKeyUsage(request: StopKeyUsageRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.StopKeyUsageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.StopKeyUsageRequest,
      StopKeyUsageResponse
    ]("stopKeyUsage", api.stopKeyUsage)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.StopKeyUsageResponse.wrap)
      .provideEnvironment(r)
    def listAliases(request: ListAliasesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.paymentcryptography.model.Alias.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.paymentcryptography.model.ListAliasesRequest,
      ListAliasesResponse,
      Alias
    ](
      "listAliases",
      api.listAliases,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.aliases().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.paymentcryptography.model.Alias.wrap(item))
      .provideEnvironment(r)
    def listAliasesPaginated(request: ListAliasesRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.ListAliasesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.ListAliasesRequest,
      ListAliasesResponse
    ]("listAliases", api.listAliases)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.ListAliasesResponse.wrap)
      .provideEnvironment(r)
    def getParametersForImport(request: GetParametersForImportRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.GetParametersForImportResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.GetParametersForImportRequest,
      GetParametersForImportResponse
    ]("getParametersForImport", api.getParametersForImport)(
      request.buildAwsValue()
    ).map(zio.aws.paymentcryptography.model.GetParametersForImportResponse.wrap)
      .provideEnvironment(r)
    def restoreKey(request: RestoreKeyRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.RestoreKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.RestoreKeyRequest,
      RestoreKeyResponse
    ]("restoreKey", api.restoreKey)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.RestoreKeyResponse.wrap)
      .provideEnvironment(r)
    def updateAlias(request: UpdateAliasRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.UpdateAliasResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.UpdateAliasRequest,
      UpdateAliasResponse
    ]("updateAlias", api.updateAlias)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.UpdateAliasResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def createAlias(request: CreateAliasRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.CreateAliasResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.CreateAliasRequest,
      CreateAliasResponse
    ]("createAlias", api.createAlias)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.CreateAliasResponse.wrap)
      .provideEnvironment(r)
    def getPublicKeyCertificate(request: GetPublicKeyCertificateRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.GetPublicKeyCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.GetPublicKeyCertificateRequest,
      GetPublicKeyCertificateResponse
    ]("getPublicKeyCertificate", api.getPublicKeyCertificate)(
      request.buildAwsValue()
    ).map(
      zio.aws.paymentcryptography.model.GetPublicKeyCertificateResponse.wrap
    ).provideEnvironment(r)
    def createKey(request: CreateKeyRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.CreateKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.CreateKeyRequest,
      CreateKeyResponse
    ]("createKey", api.createKey)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.CreateKeyResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.paymentcryptography.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.paymentcryptography.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse,
        Tag
      ](
        "listTagsForResource",
        api.listTagsForResource,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.paymentcryptography.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def startKeyUsage(request: StartKeyUsageRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.StartKeyUsageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.StartKeyUsageRequest,
      StartKeyUsageResponse
    ]("startKeyUsage", api.startKeyUsage)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.StartKeyUsageResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def importKey(request: ImportKeyRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.ImportKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.ImportKeyRequest,
      ImportKeyResponse
    ]("importKey", api.importKey)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.ImportKeyResponse.wrap)
      .provideEnvironment(r)
    def deleteAlias(request: DeleteAliasRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.DeleteAliasResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.DeleteAliasRequest,
      DeleteAliasResponse
    ]("deleteAlias", api.deleteAlias)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.DeleteAliasResponse.wrap)
      .provideEnvironment(r)
    def getAlias(request: GetAliasRequest): IO[
      AwsError,
      zio.aws.paymentcryptography.model.GetAliasResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.paymentcryptography.model.GetAliasRequest,
      GetAliasResponse
    ]("getAlias", api.getAlias)(request.buildAwsValue())
      .map(zio.aws.paymentcryptography.model.GetAliasResponse.wrap)
      .provideEnvironment(r)
    def listKeys(request: ListKeysRequest): ZStream[
      Any,
      AwsError,
      zio.aws.paymentcryptography.model.KeySummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.paymentcryptography.model.ListKeysRequest,
      ListKeysResponse,
      KeySummary
    ](
      "listKeys",
      api.listKeys,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.keys().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.paymentcryptography.model.KeySummary.wrap(item))
      .provideEnvironment(r)
    def listKeysPaginated(request: ListKeysRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.paymentcryptography.model.ListKeysRequest,
        ListKeysResponse
      ]("listKeys", api.listKeys)(request.buildAwsValue())
        .map(zio.aws.paymentcryptography.model.ListKeysResponse.wrap)
        .provideEnvironment(r)
  }
  def getKey(request: GetKeyRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.GetKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getKey(request))
  def exportKey(request: ExportKeyRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.ExportKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportKey(request))
  def deleteKey(request: DeleteKeyRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.DeleteKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteKey(request))
  def getParametersForExport(request: GetParametersForExportRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.GetParametersForExportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getParametersForExport(request))
  def stopKeyUsage(request: StopKeyUsageRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.StopKeyUsageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopKeyUsage(request))
  def listAliases(request: ListAliasesRequest): ZStream[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.Alias.ReadOnly
  ] = ZStream.serviceWithStream(_.listAliases(request))
  def listAliasesPaginated(request: ListAliasesRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.ListAliasesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAliasesPaginated(request))
  def getParametersForImport(request: GetParametersForImportRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.GetParametersForImportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getParametersForImport(request))
  def restoreKey(request: RestoreKeyRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.RestoreKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreKey(request))
  def updateAlias(request: UpdateAliasRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.UpdateAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAlias(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createAlias(request: CreateAliasRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.CreateAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAlias(request))
  def getPublicKeyCertificate(request: GetPublicKeyCertificateRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.GetPublicKeyCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPublicKeyCertificate(request))
  def createKey(request: CreateKeyRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.CreateKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKey(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def startKeyUsage(request: StartKeyUsageRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.StartKeyUsageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startKeyUsage(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def importKey(request: ImportKeyRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.ImportKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importKey(request))
  def deleteAlias(request: DeleteAliasRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.DeleteAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAlias(request))
  def getAlias(request: GetAliasRequest): ZIO[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.GetAliasResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAlias(request))
  def listKeys(request: ListKeysRequest): ZStream[
    zio.aws.paymentcryptography.PaymentCryptography,
    AwsError,
    zio.aws.paymentcryptography.model.KeySummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listKeys(request))
  def listKeysPaginated(
      request: ListKeysRequest
  ): ZIO[zio.aws.paymentcryptography.PaymentCryptography, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listKeysPaginated(request))
}
