package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteKeyResponse(key: zio.aws.paymentcryptography.model.Key) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.DeleteKeyResponse = {
    import DeleteKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.DeleteKeyResponse
      .builder()
      .key(key.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.DeleteKeyResponse.ReadOnly =
    zio.aws.paymentcryptography.model.DeleteKeyResponse.wrap(buildAwsValue())
}
object DeleteKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.DeleteKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.DeleteKeyResponse =
      zio.aws.paymentcryptography.model.DeleteKeyResponse(key.asEditable)
    def key: zio.aws.paymentcryptography.model.Key.ReadOnly
    def getKey
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.Key.ReadOnly] =
      ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.DeleteKeyResponse
  ) extends zio.aws.paymentcryptography.model.DeleteKeyResponse.ReadOnly {
    override val key: zio.aws.paymentcryptography.model.Key.ReadOnly =
      zio.aws.paymentcryptography.model.Key.wrap(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.DeleteKeyResponse
  ): zio.aws.paymentcryptography.model.DeleteKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
