package zio.aws.paymentcryptography.model
import scala.jdk.CollectionConverters.*
sealed trait KeyUsage {
  def unwrap: software.amazon.awssdk.services.paymentcryptography.model.KeyUsage
}
object KeyUsage {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptography.model.KeyUsage
  ): zio.aws.paymentcryptography.model.KeyUsage = value match {
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_B0_BASE_DERIVATION_KEY =>
      val r = TR31_B0_BASE_DERIVATION_KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_C0_CARD_VERIFICATION_KEY =>
      val r = TR31_C0_CARD_VERIFICATION_KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_D0_SYMMETRIC_DATA_ENCRYPTION_KEY =>
      val r = TR31_D0_SYMMETRIC_DATA_ENCRYPTION_KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_D1_ASYMMETRIC_KEY_FOR_DATA_ENCRYPTION =>
      val r = TR31_D1_ASYMMETRIC_KEY_FOR_DATA_ENCRYPTION
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_E0_EMV_MKEY_APP_CRYPTOGRAMS =>
      val r = TR31_E0_EMV_MKEY_APP_CRYPTOGRAMS
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_E1_EMV_MKEY_CONFIDENTIALITY =>
      val r = TR31_E1_EMV_MKEY_CONFIDENTIALITY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_E2_EMV_MKEY_INTEGRITY =>
      val r = TR31_E2_EMV_MKEY_INTEGRITY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_E4_EMV_MKEY_DYNAMIC_NUMBERS =>
      val r = TR31_E4_EMV_MKEY_DYNAMIC_NUMBERS
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_E5_EMV_MKEY_CARD_PERSONALIZATION =>
      val r = TR31_E5_EMV_MKEY_CARD_PERSONALIZATION
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_E6_EMV_MKEY_OTHER =>
      val r = TR31_E6_EMV_MKEY_OTHER
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_K0_KEY_ENCRYPTION_KEY =>
      val r = TR31_K0_KEY_ENCRYPTION_KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_K1_KEY_BLOCK_PROTECTION_KEY =>
      val r = TR31_K1_KEY_BLOCK_PROTECTION_KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_K3_ASYMMETRIC_KEY_FOR_KEY_AGREEMENT =>
      val r = TR31_K3_ASYMMETRIC_KEY_FOR_KEY_AGREEMENT
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_M3_ISO_9797_3_MAC_KEY =>
      val r = TR31_M3_ISO_9797_3_MAC_KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_M6_ISO_9797_5_CMAC_KEY =>
      val r = TR31_M6_ISO_9797_5_CMAC_KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_M7_HMAC_KEY =>
      val r = TR31_M7_HMAC_KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_P0_PIN_ENCRYPTION_KEY =>
      val r = TR31_P0_PIN_ENCRYPTION_KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_P1_PIN_GENERATION_KEY =>
      val r = TR31_P1_PIN_GENERATION_KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_S0_ASYMMETRIC_KEY_FOR_DIGITAL_SIGNATURE =>
      val r = TR31_S0_ASYMMETRIC_KEY_FOR_DIGITAL_SIGNATURE
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_V1_IBM3624_PIN_VERIFICATION_KEY =>
      val r = TR31_V1_IBM3624_PIN_VERIFICATION_KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_V2_VISA_PIN_VERIFICATION_KEY =>
      val r = TR31_V2_VISA_PIN_VERIFICATION_KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_K2_TR34_ASYMMETRIC_KEY =>
      val r = TR31_K2_TR34_ASYMMETRIC_KEY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.UNKNOWN_TO_SDK_VERSION
  }
  case object TR31_B0_BASE_DERIVATION_KEY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_B0_BASE_DERIVATION_KEY
  }
  case object TR31_C0_CARD_VERIFICATION_KEY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_C0_CARD_VERIFICATION_KEY
  }
  case object TR31_D0_SYMMETRIC_DATA_ENCRYPTION_KEY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_D0_SYMMETRIC_DATA_ENCRYPTION_KEY
  }
  case object TR31_D1_ASYMMETRIC_KEY_FOR_DATA_ENCRYPTION
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_D1_ASYMMETRIC_KEY_FOR_DATA_ENCRYPTION
  }
  case object TR31_E0_EMV_MKEY_APP_CRYPTOGRAMS
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_E0_EMV_MKEY_APP_CRYPTOGRAMS
  }
  case object TR31_E1_EMV_MKEY_CONFIDENTIALITY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_E1_EMV_MKEY_CONFIDENTIALITY
  }
  case object TR31_E2_EMV_MKEY_INTEGRITY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_E2_EMV_MKEY_INTEGRITY
  }
  case object TR31_E4_EMV_MKEY_DYNAMIC_NUMBERS
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_E4_EMV_MKEY_DYNAMIC_NUMBERS
  }
  case object TR31_E5_EMV_MKEY_CARD_PERSONALIZATION
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_E5_EMV_MKEY_CARD_PERSONALIZATION
  }
  case object TR31_E6_EMV_MKEY_OTHER
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_E6_EMV_MKEY_OTHER
  }
  case object TR31_K0_KEY_ENCRYPTION_KEY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_K0_KEY_ENCRYPTION_KEY
  }
  case object TR31_K1_KEY_BLOCK_PROTECTION_KEY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_K1_KEY_BLOCK_PROTECTION_KEY
  }
  case object TR31_K3_ASYMMETRIC_KEY_FOR_KEY_AGREEMENT
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_K3_ASYMMETRIC_KEY_FOR_KEY_AGREEMENT
  }
  case object TR31_M3_ISO_9797_3_MAC_KEY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_M3_ISO_9797_3_MAC_KEY
  }
  case object TR31_M6_ISO_9797_5_CMAC_KEY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_M6_ISO_9797_5_CMAC_KEY
  }
  case object TR31_M7_HMAC_KEY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_M7_HMAC_KEY
  }
  case object TR31_P0_PIN_ENCRYPTION_KEY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_P0_PIN_ENCRYPTION_KEY
  }
  case object TR31_P1_PIN_GENERATION_KEY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_P1_PIN_GENERATION_KEY
  }
  case object TR31_S0_ASYMMETRIC_KEY_FOR_DIGITAL_SIGNATURE
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_S0_ASYMMETRIC_KEY_FOR_DIGITAL_SIGNATURE
  }
  case object TR31_V1_IBM3624_PIN_VERIFICATION_KEY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_V1_IBM3624_PIN_VERIFICATION_KEY
  }
  case object TR31_V2_VISA_PIN_VERIFICATION_KEY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_V2_VISA_PIN_VERIFICATION_KEY
  }
  case object TR31_K2_TR34_ASYMMETRIC_KEY
      extends zio.aws.paymentcryptography.model.KeyUsage {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyUsage =
      software.amazon.awssdk.services.paymentcryptography.model.KeyUsage.TR31_K2_TR34_ASYMMETRIC_KEY
  }
}
