package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.{
  KeyArnOrKeyAliasType,
  Tr31WrappedKeyBlock
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ImportTr31KeyBlock(
    wrappedKeyBlock: Tr31WrappedKeyBlock,
    wrappingKeyIdentifier: KeyArnOrKeyAliasType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ImportTr31KeyBlock = {
    import ImportTr31KeyBlock.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ImportTr31KeyBlock
      .builder()
      .wrappedKeyBlock(
        Tr31WrappedKeyBlock.unwrap(wrappedKeyBlock): java.lang.String
      )
      .wrappingKeyIdentifier(
        KeyArnOrKeyAliasType.unwrap(wrappingKeyIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.ImportTr31KeyBlock.ReadOnly =
    zio.aws.paymentcryptography.model.ImportTr31KeyBlock.wrap(buildAwsValue())
}
object ImportTr31KeyBlock {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ImportTr31KeyBlock
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.ImportTr31KeyBlock =
      zio.aws.paymentcryptography.model
        .ImportTr31KeyBlock(wrappedKeyBlock, wrappingKeyIdentifier)
    def wrappedKeyBlock: Tr31WrappedKeyBlock
    def wrappingKeyIdentifier: KeyArnOrKeyAliasType
    def getWrappedKeyBlock: ZIO[Any, Nothing, Tr31WrappedKeyBlock] =
      ZIO.succeed(wrappedKeyBlock)
    def getWrappingKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(wrappingKeyIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ImportTr31KeyBlock
  ) extends zio.aws.paymentcryptography.model.ImportTr31KeyBlock.ReadOnly {
    override val wrappedKeyBlock: Tr31WrappedKeyBlock =
      zio.aws.paymentcryptography.model.primitives
        .Tr31WrappedKeyBlock(impl.wrappedKeyBlock())
    override val wrappingKeyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptography.model.primitives
        .KeyArnOrKeyAliasType(impl.wrappingKeyIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ImportTr31KeyBlock
  ): zio.aws.paymentcryptography.model.ImportTr31KeyBlock.ReadOnly =
    new Wrapper(impl)
}
