package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.{
  CertificateType,
  KeyArnOrKeyAliasType
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TrustedCertificatePublicKey(
    certificateAuthorityPublicKeyIdentifier: KeyArnOrKeyAliasType,
    keyAttributes: zio.aws.paymentcryptography.model.KeyAttributes,
    publicKeyCertificate: CertificateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.TrustedCertificatePublicKey = {
    import TrustedCertificatePublicKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.TrustedCertificatePublicKey
      .builder()
      .certificateAuthorityPublicKeyIdentifier(
        KeyArnOrKeyAliasType.unwrap(
          certificateAuthorityPublicKeyIdentifier
        ): java.lang.String
      )
      .keyAttributes(keyAttributes.buildAwsValue())
      .publicKeyCertificate(
        CertificateType.unwrap(publicKeyCertificate): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.TrustedCertificatePublicKey.ReadOnly =
    zio.aws.paymentcryptography.model.TrustedCertificatePublicKey
      .wrap(buildAwsValue())
}
object TrustedCertificatePublicKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.TrustedCertificatePublicKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptography.model.TrustedCertificatePublicKey =
      zio.aws.paymentcryptography.model.TrustedCertificatePublicKey(
        certificateAuthorityPublicKeyIdentifier,
        keyAttributes.asEditable,
        publicKeyCertificate
      )
    def certificateAuthorityPublicKeyIdentifier: KeyArnOrKeyAliasType
    def keyAttributes: zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly
    def publicKeyCertificate: CertificateType
    def getCertificateAuthorityPublicKeyIdentifier
        : ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(certificateAuthorityPublicKeyIdentifier)
    def getKeyAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly
    ] = ZIO.succeed(keyAttributes)
    def getPublicKeyCertificate: ZIO[Any, Nothing, CertificateType] =
      ZIO.succeed(publicKeyCertificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.TrustedCertificatePublicKey
  ) extends zio.aws.paymentcryptography.model.TrustedCertificatePublicKey.ReadOnly {
    override val certificateAuthorityPublicKeyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptography.model.primitives
        .KeyArnOrKeyAliasType(impl.certificateAuthorityPublicKeyIdentifier())
    override val keyAttributes
        : zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly =
      zio.aws.paymentcryptography.model.KeyAttributes.wrap(impl.keyAttributes())
    override val publicKeyCertificate: CertificateType =
      zio.aws.paymentcryptography.model.primitives
        .CertificateType(impl.publicKeyCertificate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.TrustedCertificatePublicKey
  ): zio.aws.paymentcryptography.model.TrustedCertificatePublicKey.ReadOnly =
    new Wrapper(impl)
}
