package zio.aws.paymentcryptography.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.paymentcryptography.model.primitives.{
  KeyCheckValue,
  KeyArn,
  Timestamp
}
import scala.jdk.CollectionConverters.*
final case class Key(
    createTimestamp: Timestamp,
    deletePendingTimestamp: Optional[Timestamp] = Optional.Absent,
    deleteTimestamp: Optional[Timestamp] = Optional.Absent,
    enabled: Boolean,
    exportable: Boolean,
    keyArn: KeyArn,
    keyAttributes: zio.aws.paymentcryptography.model.KeyAttributes,
    keyCheckValue: KeyCheckValue,
    keyCheckValueAlgorithm: zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm,
    keyOrigin: zio.aws.paymentcryptography.model.KeyOrigin,
    keyState: zio.aws.paymentcryptography.model.KeyState,
    usageStartTimestamp: Optional[Timestamp] = Optional.Absent,
    usageStopTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.Key = {
    import Key.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.Key
      .builder()
      .createTimestamp(Timestamp.unwrap(createTimestamp): Instant)
      .optionallyWith(
        deletePendingTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.deletePendingTimestamp)
      .optionallyWith(
        deleteTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.deleteTimestamp)
      .enabled(enabled: java.lang.Boolean)
      .exportable(exportable: java.lang.Boolean)
      .keyArn(KeyArn.unwrap(keyArn): java.lang.String)
      .keyAttributes(keyAttributes.buildAwsValue())
      .keyCheckValue(KeyCheckValue.unwrap(keyCheckValue): java.lang.String)
      .keyCheckValueAlgorithm(keyCheckValueAlgorithm.unwrap)
      .keyOrigin(keyOrigin.unwrap)
      .keyState(keyState.unwrap)
      .optionallyWith(
        usageStartTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.usageStartTimestamp)
      .optionallyWith(
        usageStopTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.usageStopTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.Key.ReadOnly =
    zio.aws.paymentcryptography.model.Key.wrap(buildAwsValue())
}
object Key {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.Key
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.Key =
      zio.aws.paymentcryptography.model.Key(
        createTimestamp,
        deletePendingTimestamp.map(value => value),
        deleteTimestamp.map(value => value),
        enabled,
        exportable,
        keyArn,
        keyAttributes.asEditable,
        keyCheckValue,
        keyCheckValueAlgorithm,
        keyOrigin,
        keyState,
        usageStartTimestamp.map(value => value),
        usageStopTimestamp.map(value => value)
      )
    def createTimestamp: Timestamp
    def deletePendingTimestamp: Optional[Timestamp]
    def deleteTimestamp: Optional[Timestamp]
    def enabled: Boolean
    def exportable: Boolean
    def keyArn: KeyArn
    def keyAttributes: zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly
    def keyCheckValue: KeyCheckValue
    def keyCheckValueAlgorithm
        : zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm
    def keyOrigin: zio.aws.paymentcryptography.model.KeyOrigin
    def keyState: zio.aws.paymentcryptography.model.KeyState
    def usageStartTimestamp: Optional[Timestamp]
    def usageStopTimestamp: Optional[Timestamp]
    def getCreateTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(createTimestamp)
    def getDeletePendingTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("deletePendingTimestamp", deletePendingTimestamp)
    def getDeleteTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("deleteTimestamp", deleteTimestamp)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getExportable: ZIO[Any, Nothing, Boolean] = ZIO.succeed(exportable)
    def getKeyArn: ZIO[Any, Nothing, KeyArn] = ZIO.succeed(keyArn)
    def getKeyAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly
    ] = ZIO.succeed(keyAttributes)
    def getKeyCheckValue: ZIO[Any, Nothing, KeyCheckValue] =
      ZIO.succeed(keyCheckValue)
    def getKeyCheckValueAlgorithm: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm
    ] = ZIO.succeed(keyCheckValueAlgorithm)
    def getKeyOrigin
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.KeyOrigin] =
      ZIO.succeed(keyOrigin)
    def getKeyState
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.KeyState] =
      ZIO.succeed(keyState)
    def getUsageStartTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("usageStartTimestamp", usageStartTimestamp)
    def getUsageStopTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("usageStopTimestamp", usageStopTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.Key
  ) extends zio.aws.paymentcryptography.model.Key.ReadOnly {
    override val createTimestamp: Timestamp =
      zio.aws.paymentcryptography.model.primitives
        .Timestamp(impl.createTimestamp())
    override val deletePendingTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletePendingTimestamp())
        .map(value =>
          zio.aws.paymentcryptography.model.primitives.Timestamp(value)
        )
    override val deleteTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteTimestamp())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.Timestamp(value)
      )
    override val enabled: Boolean = impl.enabled(): Boolean
    override val exportable: Boolean = impl.exportable(): Boolean
    override val keyArn: KeyArn =
      zio.aws.paymentcryptography.model.primitives.KeyArn(impl.keyArn())
    override val keyAttributes
        : zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly =
      zio.aws.paymentcryptography.model.KeyAttributes.wrap(impl.keyAttributes())
    override val keyCheckValue: KeyCheckValue =
      zio.aws.paymentcryptography.model.primitives
        .KeyCheckValue(impl.keyCheckValue())
    override val keyCheckValueAlgorithm
        : zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm =
      zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm
        .wrap(impl.keyCheckValueAlgorithm())
    override val keyOrigin: zio.aws.paymentcryptography.model.KeyOrigin =
      zio.aws.paymentcryptography.model.KeyOrigin.wrap(impl.keyOrigin())
    override val keyState: zio.aws.paymentcryptography.model.KeyState =
      zio.aws.paymentcryptography.model.KeyState.wrap(impl.keyState())
    override val usageStartTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usageStartTimestamp())
        .map(value =>
          zio.aws.paymentcryptography.model.primitives.Timestamp(value)
        )
    override val usageStopTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.usageStopTimestamp())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.Key
  ): zio.aws.paymentcryptography.model.Key.ReadOnly = new Wrapper(impl)
}
