package zio.aws.paymentcryptography.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.paymentcryptography.model.primitives.{NextToken, MaxResults}
import scala.jdk.CollectionConverters.*
final case class ListKeysRequest(
    keyState: Optional[zio.aws.paymentcryptography.model.KeyState] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ListKeysRequest = {
    import ListKeysRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ListKeysRequest
      .builder()
      .optionallyWith(keyState.map(value => value.unwrap))(_.keyState)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.ListKeysRequest.ReadOnly =
    zio.aws.paymentcryptography.model.ListKeysRequest.wrap(buildAwsValue())
}
object ListKeysRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ListKeysRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.ListKeysRequest =
      zio.aws.paymentcryptography.model.ListKeysRequest(
        keyState.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def keyState: Optional[zio.aws.paymentcryptography.model.KeyState]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getKeyState
        : ZIO[Any, AwsError, zio.aws.paymentcryptography.model.KeyState] =
      AwsError.unwrapOptionField("keyState", keyState)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ListKeysRequest
  ) extends zio.aws.paymentcryptography.model.ListKeysRequest.ReadOnly {
    override val keyState
        : Optional[zio.aws.paymentcryptography.model.KeyState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyState())
        .map(value => zio.aws.paymentcryptography.model.KeyState.wrap(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.MaxResults(value)
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ListKeysRequest
  ): zio.aws.paymentcryptography.model.ListKeysRequest.ReadOnly = new Wrapper(
    impl
  )
}
