package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportKeyRequest(
    enabled: Optional[Boolean] = Optional.Absent,
    keyCheckValueAlgorithm: Optional[
      zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm
    ] = Optional.Absent,
    keyMaterial: zio.aws.paymentcryptography.model.ImportKeyMaterial,
    tags: Optional[Iterable[zio.aws.paymentcryptography.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ImportKeyRequest = {
    import ImportKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ImportKeyRequest
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(keyCheckValueAlgorithm.map(value => value.unwrap))(
        _.keyCheckValueAlgorithm
      )
      .keyMaterial(keyMaterial.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.ImportKeyRequest.ReadOnly =
    zio.aws.paymentcryptography.model.ImportKeyRequest.wrap(buildAwsValue())
}
object ImportKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ImportKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.ImportKeyRequest =
      zio.aws.paymentcryptography.model.ImportKeyRequest(
        enabled.map(value => value),
        keyCheckValueAlgorithm.map(value => value),
        keyMaterial.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def enabled: Optional[Boolean]
    def keyCheckValueAlgorithm
        : Optional[zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm]
    def keyMaterial
        : zio.aws.paymentcryptography.model.ImportKeyMaterial.ReadOnly
    def tags: Optional[List[zio.aws.paymentcryptography.model.Tag.ReadOnly]]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getKeyCheckValueAlgorithm: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm
    ] = AwsError.unwrapOptionField(
      "keyCheckValueAlgorithm",
      keyCheckValueAlgorithm
    )
    def getKeyMaterial: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptography.model.ImportKeyMaterial.ReadOnly
    ] = ZIO.succeed(keyMaterial)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.paymentcryptography.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ImportKeyRequest
  ) extends zio.aws.paymentcryptography.model.ImportKeyRequest.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val keyCheckValueAlgorithm
        : Optional[zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyCheckValueAlgorithm())
        .map(value =>
          zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm.wrap(value)
        )
    override val keyMaterial
        : zio.aws.paymentcryptography.model.ImportKeyMaterial.ReadOnly =
      zio.aws.paymentcryptography.model.ImportKeyMaterial
        .wrap(impl.keyMaterial())
    override val tags
        : Optional[List[zio.aws.paymentcryptography.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.paymentcryptography.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ImportKeyRequest
  ): zio.aws.paymentcryptography.model.ImportKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
