package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.CertificateType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RootCertificatePublicKey(
    keyAttributes: zio.aws.paymentcryptography.model.KeyAttributes,
    publicKeyCertificate: CertificateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.RootCertificatePublicKey = {
    import RootCertificatePublicKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.RootCertificatePublicKey
      .builder()
      .keyAttributes(keyAttributes.buildAwsValue())
      .publicKeyCertificate(
        CertificateType.unwrap(publicKeyCertificate): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.RootCertificatePublicKey.ReadOnly =
    zio.aws.paymentcryptography.model.RootCertificatePublicKey
      .wrap(buildAwsValue())
}
object RootCertificatePublicKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.RootCertificatePublicKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.RootCertificatePublicKey =
      zio.aws.paymentcryptography.model.RootCertificatePublicKey(
        keyAttributes.asEditable,
        publicKeyCertificate
      )
    def keyAttributes: zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly
    def publicKeyCertificate: CertificateType
    def getKeyAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly
    ] = ZIO.succeed(keyAttributes)
    def getPublicKeyCertificate: ZIO[Any, Nothing, CertificateType] =
      ZIO.succeed(publicKeyCertificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.RootCertificatePublicKey
  ) extends zio.aws.paymentcryptography.model.RootCertificatePublicKey.ReadOnly {
    override val keyAttributes
        : zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly =
      zio.aws.paymentcryptography.model.KeyAttributes.wrap(impl.keyAttributes())
    override val publicKeyCertificate: CertificateType =
      zio.aws.paymentcryptography.model.primitives
        .CertificateType(impl.publicKeyCertificate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.RootCertificatePublicKey
  ): zio.aws.paymentcryptography.model.RootCertificatePublicKey.ReadOnly =
    new Wrapper(impl)
}
