package zio.aws.paymentcryptography.model
import scala.jdk.CollectionConverters._
sealed trait KeyOrigin {
  def unwrap
      : software.amazon.awssdk.services.paymentcryptography.model.KeyOrigin
}
object KeyOrigin {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptography.model.KeyOrigin
  ): zio.aws.paymentcryptography.model.KeyOrigin = value match {
    case software.amazon.awssdk.services.paymentcryptography.model.KeyOrigin.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyOrigin.EXTERNAL =>
      val r = EXTERNAL
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyOrigin.AWS_PAYMENT_CRYPTOGRAPHY =>
      val r = AWS_PAYMENT_CRYPTOGRAPHY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptography.model.KeyOrigin {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyOrigin =
      software.amazon.awssdk.services.paymentcryptography.model.KeyOrigin.UNKNOWN_TO_SDK_VERSION
  }
  case object EXTERNAL extends zio.aws.paymentcryptography.model.KeyOrigin {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyOrigin =
      software.amazon.awssdk.services.paymentcryptography.model.KeyOrigin.EXTERNAL
  }
  case object AWS_PAYMENT_CRYPTOGRAPHY
      extends zio.aws.paymentcryptography.model.KeyOrigin {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyOrigin =
      software.amazon.awssdk.services.paymentcryptography.model.KeyOrigin.AWS_PAYMENT_CRYPTOGRAPHY
  }
}
