package zio.aws.paymentcryptography.model
import scala.jdk.CollectionConverters._
sealed trait KeyClass {
  def unwrap: software.amazon.awssdk.services.paymentcryptography.model.KeyClass
}
object KeyClass {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptography.model.KeyClass
  ): zio.aws.paymentcryptography.model.KeyClass = value match {
    case software.amazon.awssdk.services.paymentcryptography.model.KeyClass.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyClass.SYMMETRIC_KEY =>
      val r = SYMMETRIC_KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyClass.ASYMMETRIC_KEY_PAIR =>
      val r = ASYMMETRIC_KEY_PAIR
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyClass.PRIVATE_KEY =>
      val r = PRIVATE_KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyClass.PUBLIC_KEY =>
      val r = PUBLIC_KEY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptography.model.KeyClass {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyClass =
      software.amazon.awssdk.services.paymentcryptography.model.KeyClass.UNKNOWN_TO_SDK_VERSION
  }
  case object SYMMETRIC_KEY extends zio.aws.paymentcryptography.model.KeyClass {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyClass =
      software.amazon.awssdk.services.paymentcryptography.model.KeyClass.SYMMETRIC_KEY
  }
  case object ASYMMETRIC_KEY_PAIR
      extends zio.aws.paymentcryptography.model.KeyClass {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyClass =
      software.amazon.awssdk.services.paymentcryptography.model.KeyClass.ASYMMETRIC_KEY_PAIR
  }
  case object PRIVATE_KEY extends zio.aws.paymentcryptography.model.KeyClass {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyClass =
      software.amazon.awssdk.services.paymentcryptography.model.KeyClass.PRIVATE_KEY
  }
  case object PUBLIC_KEY extends zio.aws.paymentcryptography.model.KeyClass {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyClass =
      software.amazon.awssdk.services.paymentcryptography.model.KeyClass.PUBLIC_KEY
  }
}
