package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.{
  CertificateType,
  Timestamp,
  ImportTokenId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetParametersForImportResponse(
    importToken: ImportTokenId,
    parametersValidUntilTimestamp: Timestamp,
    wrappingKeyAlgorithm: zio.aws.paymentcryptography.model.KeyAlgorithm,
    wrappingKeyCertificate: CertificateType,
    wrappingKeyCertificateChain: CertificateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.GetParametersForImportResponse = {
    import GetParametersForImportResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.GetParametersForImportResponse
      .builder()
      .importToken(ImportTokenId.unwrap(importToken): java.lang.String)
      .parametersValidUntilTimestamp(
        Timestamp.unwrap(parametersValidUntilTimestamp): Instant
      )
      .wrappingKeyAlgorithm(wrappingKeyAlgorithm.unwrap)
      .wrappingKeyCertificate(
        CertificateType.unwrap(wrappingKeyCertificate): java.lang.String
      )
      .wrappingKeyCertificateChain(
        CertificateType.unwrap(wrappingKeyCertificateChain): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.GetParametersForImportResponse.ReadOnly =
    zio.aws.paymentcryptography.model.GetParametersForImportResponse
      .wrap(buildAwsValue())
}
object GetParametersForImportResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.GetParametersForImportResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptography.model.GetParametersForImportResponse =
      zio.aws.paymentcryptography.model.GetParametersForImportResponse(
        importToken,
        parametersValidUntilTimestamp,
        wrappingKeyAlgorithm,
        wrappingKeyCertificate,
        wrappingKeyCertificateChain
      )
    def importToken: ImportTokenId
    def parametersValidUntilTimestamp: Timestamp
    def wrappingKeyAlgorithm: zio.aws.paymentcryptography.model.KeyAlgorithm
    def wrappingKeyCertificate: CertificateType
    def wrappingKeyCertificateChain: CertificateType
    def getImportToken: ZIO[Any, Nothing, ImportTokenId] =
      ZIO.succeed(importToken)
    def getParametersValidUntilTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(parametersValidUntilTimestamp)
    def getWrappingKeyAlgorithm
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.KeyAlgorithm] =
      ZIO.succeed(wrappingKeyAlgorithm)
    def getWrappingKeyCertificate: ZIO[Any, Nothing, CertificateType] =
      ZIO.succeed(wrappingKeyCertificate)
    def getWrappingKeyCertificateChain: ZIO[Any, Nothing, CertificateType] =
      ZIO.succeed(wrappingKeyCertificateChain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetParametersForImportResponse
  ) extends zio.aws.paymentcryptography.model.GetParametersForImportResponse.ReadOnly {
    override val importToken: ImportTokenId =
      zio.aws.paymentcryptography.model.primitives
        .ImportTokenId(impl.importToken())
    override val parametersValidUntilTimestamp: Timestamp =
      zio.aws.paymentcryptography.model.primitives
        .Timestamp(impl.parametersValidUntilTimestamp())
    override val wrappingKeyAlgorithm
        : zio.aws.paymentcryptography.model.KeyAlgorithm =
      zio.aws.paymentcryptography.model.KeyAlgorithm
        .wrap(impl.wrappingKeyAlgorithm())
    override val wrappingKeyCertificate: CertificateType =
      zio.aws.paymentcryptography.model.primitives
        .CertificateType(impl.wrappingKeyCertificate())
    override val wrappingKeyCertificateChain: CertificateType =
      zio.aws.paymentcryptography.model.primitives
        .CertificateType(impl.wrappingKeyCertificateChain())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetParametersForImportResponse
  ): zio.aws.paymentcryptography.model.GetParametersForImportResponse.ReadOnly =
    new Wrapper(impl)
}
