package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.KeyArnOrKeyAliasType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExportKeyRequest(
    exportKeyIdentifier: KeyArnOrKeyAliasType,
    keyMaterial: zio.aws.paymentcryptography.model.ExportKeyMaterial
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ExportKeyRequest = {
    import ExportKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ExportKeyRequest
      .builder()
      .exportKeyIdentifier(
        KeyArnOrKeyAliasType.unwrap(exportKeyIdentifier): java.lang.String
      )
      .keyMaterial(keyMaterial.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.ExportKeyRequest.ReadOnly =
    zio.aws.paymentcryptography.model.ExportKeyRequest.wrap(buildAwsValue())
}
object ExportKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ExportKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.ExportKeyRequest =
      zio.aws.paymentcryptography.model
        .ExportKeyRequest(exportKeyIdentifier, keyMaterial.asEditable)
    def exportKeyIdentifier: KeyArnOrKeyAliasType
    def keyMaterial
        : zio.aws.paymentcryptography.model.ExportKeyMaterial.ReadOnly
    def getExportKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(exportKeyIdentifier)
    def getKeyMaterial: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptography.model.ExportKeyMaterial.ReadOnly
    ] = ZIO.succeed(keyMaterial)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ExportKeyRequest
  ) extends zio.aws.paymentcryptography.model.ExportKeyRequest.ReadOnly {
    override val exportKeyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptography.model.primitives
        .KeyArnOrKeyAliasType(impl.exportKeyIdentifier())
    override val keyMaterial
        : zio.aws.paymentcryptography.model.ExportKeyMaterial.ReadOnly =
      zio.aws.paymentcryptography.model.ExportKeyMaterial
        .wrap(impl.keyMaterial())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ExportKeyRequest
  ): zio.aws.paymentcryptography.model.ExportKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
