package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportKeyMaterial(
    tr31KeyBlock: Optional[
      zio.aws.paymentcryptography.model.ExportTr31KeyBlock
    ] = Optional.Absent,
    tr34KeyBlock: Optional[
      zio.aws.paymentcryptography.model.ExportTr34KeyBlock
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ExportKeyMaterial = {
    import ExportKeyMaterial.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ExportKeyMaterial
      .builder()
      .optionallyWith(tr31KeyBlock.map(value => value.buildAwsValue()))(
        _.tr31KeyBlock
      )
      .optionallyWith(tr34KeyBlock.map(value => value.buildAwsValue()))(
        _.tr34KeyBlock
      )
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.ExportKeyMaterial.ReadOnly =
    zio.aws.paymentcryptography.model.ExportKeyMaterial.wrap(buildAwsValue())
}
object ExportKeyMaterial {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ExportKeyMaterial
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.ExportKeyMaterial =
      zio.aws.paymentcryptography.model.ExportKeyMaterial(
        tr31KeyBlock.map(value => value.asEditable),
        tr34KeyBlock.map(value => value.asEditable)
      )
    def tr31KeyBlock: Optional[
      zio.aws.paymentcryptography.model.ExportTr31KeyBlock.ReadOnly
    ]
    def tr34KeyBlock: Optional[
      zio.aws.paymentcryptography.model.ExportTr34KeyBlock.ReadOnly
    ]
    def getTr31KeyBlock: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptography.model.ExportTr31KeyBlock.ReadOnly
    ] = AwsError.unwrapOptionField("tr31KeyBlock", tr31KeyBlock)
    def getTr34KeyBlock: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptography.model.ExportTr34KeyBlock.ReadOnly
    ] = AwsError.unwrapOptionField("tr34KeyBlock", tr34KeyBlock)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ExportKeyMaterial
  ) extends zio.aws.paymentcryptography.model.ExportKeyMaterial.ReadOnly {
    override val tr31KeyBlock: Optional[
      zio.aws.paymentcryptography.model.ExportTr31KeyBlock.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tr31KeyBlock())
      .map(value =>
        zio.aws.paymentcryptography.model.ExportTr31KeyBlock.wrap(value)
      )
    override val tr34KeyBlock: Optional[
      zio.aws.paymentcryptography.model.ExportTr34KeyBlock.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tr34KeyBlock())
      .map(value =>
        zio.aws.paymentcryptography.model.ExportTr34KeyBlock.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ExportKeyMaterial
  ): zio.aws.paymentcryptography.model.ExportKeyMaterial.ReadOnly = new Wrapper(
    impl
  )
}
