package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateKeyResponse(key: zio.aws.paymentcryptography.model.Key) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.CreateKeyResponse = {
    import CreateKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.CreateKeyResponse
      .builder()
      .key(key.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.CreateKeyResponse.ReadOnly =
    zio.aws.paymentcryptography.model.CreateKeyResponse.wrap(buildAwsValue())
}
object CreateKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.CreateKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.CreateKeyResponse =
      zio.aws.paymentcryptography.model.CreateKeyResponse(key.asEditable)
    def key: zio.aws.paymentcryptography.model.Key.ReadOnly
    def getKey
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.Key.ReadOnly] =
      ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.CreateKeyResponse
  ) extends zio.aws.paymentcryptography.model.CreateKeyResponse.ReadOnly {
    override val key: zio.aws.paymentcryptography.model.Key.ReadOnly =
      zio.aws.paymentcryptography.model.Key.wrap(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.CreateKeyResponse
  ): zio.aws.paymentcryptography.model.CreateKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
