package zio.aws.paymentcryptography.model
import scala.jdk.CollectionConverters._
sealed trait Tr34KeyBlockFormat {
  def unwrap: software.amazon.awssdk.services.paymentcryptography.model.Tr34KeyBlockFormat
}
object Tr34KeyBlockFormat {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptography.model.Tr34KeyBlockFormat
  ): zio.aws.paymentcryptography.model.Tr34KeyBlockFormat = value match {
    case software.amazon.awssdk.services.paymentcryptography.model.Tr34KeyBlockFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptography.model.Tr34KeyBlockFormat.X9_TR34_2012 =>
      val r = X9_TR34_2012
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptography.model.Tr34KeyBlockFormat {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.Tr34KeyBlockFormat =
      software.amazon.awssdk.services.paymentcryptography.model.Tr34KeyBlockFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object X9_TR34_2012
      extends zio.aws.paymentcryptography.model.Tr34KeyBlockFormat {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.Tr34KeyBlockFormat =
      software.amazon.awssdk.services.paymentcryptography.model.Tr34KeyBlockFormat.X9_TR34_2012
  }
}
