package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.PrimitiveBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class KeyModesOfUse(
    decrypt: Optional[PrimitiveBoolean] = Optional.Absent,
    deriveKey: Optional[PrimitiveBoolean] = Optional.Absent,
    encrypt: Optional[PrimitiveBoolean] = Optional.Absent,
    generate: Optional[PrimitiveBoolean] = Optional.Absent,
    noRestrictions: Optional[PrimitiveBoolean] = Optional.Absent,
    sign: Optional[PrimitiveBoolean] = Optional.Absent,
    unwrap: Optional[PrimitiveBoolean] = Optional.Absent,
    verify: Optional[PrimitiveBoolean] = Optional.Absent,
    wrap: Optional[PrimitiveBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.KeyModesOfUse = {
    import KeyModesOfUse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.KeyModesOfUse
      .builder()
      .optionallyWith(
        decrypt.map(value => PrimitiveBoolean.unwrap(value): java.lang.Boolean)
      )(_.decrypt)
      .optionallyWith(
        deriveKey.map(value =>
          PrimitiveBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.deriveKey)
      .optionallyWith(
        encrypt.map(value => PrimitiveBoolean.unwrap(value): java.lang.Boolean)
      )(_.encrypt)
      .optionallyWith(
        generate.map(value => PrimitiveBoolean.unwrap(value): java.lang.Boolean)
      )(_.generate)
      .optionallyWith(
        noRestrictions.map(value =>
          PrimitiveBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.noRestrictions)
      .optionallyWith(
        sign.map(value => PrimitiveBoolean.unwrap(value): java.lang.Boolean)
      )(_.sign)
      .optionallyWith(
        unwrap.map(value => PrimitiveBoolean.unwrap(value): java.lang.Boolean)
      )(_.unwrap)
      .optionallyWith(
        verify.map(value => PrimitiveBoolean.unwrap(value): java.lang.Boolean)
      )(_.verify)
      .optionallyWith(
        wrap.map(value => PrimitiveBoolean.unwrap(value): java.lang.Boolean)
      )(_.wrap)
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.KeyModesOfUse.ReadOnly =
    zio.aws.paymentcryptography.model.KeyModesOfUse.wrap(buildAwsValue())
}
object KeyModesOfUse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.KeyModesOfUse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.KeyModesOfUse =
      zio.aws.paymentcryptography.model.KeyModesOfUse(
        decrypt.map(value => value),
        deriveKey.map(value => value),
        encrypt.map(value => value),
        generate.map(value => value),
        noRestrictions.map(value => value),
        sign.map(value => value),
        unwrap.map(value => value),
        verify.map(value => value),
        wrap.map(value => value)
      )
    def decrypt: Optional[PrimitiveBoolean]
    def deriveKey: Optional[PrimitiveBoolean]
    def encrypt: Optional[PrimitiveBoolean]
    def generate: Optional[PrimitiveBoolean]
    def noRestrictions: Optional[PrimitiveBoolean]
    def sign: Optional[PrimitiveBoolean]
    def unwrap: Optional[PrimitiveBoolean]
    def verify: Optional[PrimitiveBoolean]
    def wrap: Optional[PrimitiveBoolean]
    def getDecrypt: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("decrypt", decrypt)
    def getDeriveKey: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("deriveKey", deriveKey)
    def getEncrypt: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("encrypt", encrypt)
    def getGenerate: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("generate", generate)
    def getNoRestrictions: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("noRestrictions", noRestrictions)
    def getSign: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("sign", sign)
    def getUnwrap: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("unwrap", unwrap)
    def getVerify: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("verify", verify)
    def getWrap: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("wrap", wrap)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.KeyModesOfUse
  ) extends zio.aws.paymentcryptography.model.KeyModesOfUse.ReadOnly {
    override val decrypt: Optional[PrimitiveBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.decrypt())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.PrimitiveBoolean(value)
      )
    override val deriveKey: Optional[PrimitiveBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deriveKey())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.PrimitiveBoolean(value)
      )
    override val encrypt: Optional[PrimitiveBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypt())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.PrimitiveBoolean(value)
      )
    override val generate: Optional[PrimitiveBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.generate())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.PrimitiveBoolean(value)
      )
    override val noRestrictions: Optional[PrimitiveBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noRestrictions())
        .map(value =>
          zio.aws.paymentcryptography.model.primitives.PrimitiveBoolean(value)
        )
    override val sign: Optional[PrimitiveBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.sign())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.PrimitiveBoolean(value)
      )
    override val unwrap: Optional[PrimitiveBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.unwrap())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.PrimitiveBoolean(value)
      )
    override val verify: Optional[PrimitiveBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.verify())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.PrimitiveBoolean(value)
      )
    override val wrap: Optional[PrimitiveBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.wrap())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.PrimitiveBoolean(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.KeyModesOfUse
  ): zio.aws.paymentcryptography.model.KeyModesOfUse.ReadOnly = new Wrapper(
    impl
  )
}
