package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.{KeyArn, AliasName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAliasRequest(
    aliasName: AliasName,
    keyArn: Optional[KeyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.UpdateAliasRequest = {
    import UpdateAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.UpdateAliasRequest
      .builder()
      .aliasName(AliasName.unwrap(aliasName): java.lang.String)
      .optionallyWith(
        keyArn.map(value => KeyArn.unwrap(value): java.lang.String)
      )(_.keyArn)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.UpdateAliasRequest.ReadOnly =
    zio.aws.paymentcryptography.model.UpdateAliasRequest.wrap(buildAwsValue())
}
object UpdateAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.UpdateAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.UpdateAliasRequest =
      zio.aws.paymentcryptography.model
        .UpdateAliasRequest(aliasName, keyArn.map(value => value))
    def aliasName: AliasName
    def keyArn: Optional[KeyArn]
    def getAliasName: ZIO[Any, Nothing, AliasName] = ZIO.succeed(aliasName)
    def getKeyArn: ZIO[Any, AwsError, KeyArn] =
      AwsError.unwrapOptionField("keyArn", keyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.UpdateAliasRequest
  ) extends zio.aws.paymentcryptography.model.UpdateAliasRequest.ReadOnly {
    override val aliasName: AliasName =
      zio.aws.paymentcryptography.model.primitives.AliasName(impl.aliasName())
    override val keyArn: Optional[KeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.keyArn())
      .map(value => zio.aws.paymentcryptography.model.primitives.KeyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.UpdateAliasRequest
  ): zio.aws.paymentcryptography.model.UpdateAliasRequest.ReadOnly =
    new Wrapper(impl)
}
