package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ResourceArn,
    tags: Iterable[zio.aws.paymentcryptography.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.TagResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.TagResourceRequest.ReadOnly =
    zio.aws.paymentcryptography.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.TagResourceRequest =
      zio.aws.paymentcryptography.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: ResourceArn
    def tags: List[zio.aws.paymentcryptography.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.paymentcryptography.model.Tag.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.TagResourceRequest
  ) extends zio.aws.paymentcryptography.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.paymentcryptography.model.primitives
        .ResourceArn(impl.resourceArn())
    override val tags: List[zio.aws.paymentcryptography.model.Tag.ReadOnly] =
      impl
        .tags()
        .asScala
        .map { item =>
          zio.aws.paymentcryptography.model.Tag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.TagResourceRequest
  ): zio.aws.paymentcryptography.model.TagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
