package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RestoreKeyResponse(
    key: zio.aws.paymentcryptography.model.Key
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.RestoreKeyResponse = {
    import RestoreKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.RestoreKeyResponse
      .builder()
      .key(key.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.RestoreKeyResponse.ReadOnly =
    zio.aws.paymentcryptography.model.RestoreKeyResponse.wrap(buildAwsValue())
}
object RestoreKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.RestoreKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.RestoreKeyResponse =
      zio.aws.paymentcryptography.model.RestoreKeyResponse(key.asEditable)
    def key: zio.aws.paymentcryptography.model.Key.ReadOnly
    def getKey
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.Key.ReadOnly] =
      ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.RestoreKeyResponse
  ) extends zio.aws.paymentcryptography.model.RestoreKeyResponse.ReadOnly {
    override val key: zio.aws.paymentcryptography.model.Key.ReadOnly =
      zio.aws.paymentcryptography.model.Key.wrap(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.RestoreKeyResponse
  ): zio.aws.paymentcryptography.model.RestoreKeyResponse.ReadOnly =
    new Wrapper(impl)
}
