package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateAliasResponse(
    alias: zio.aws.paymentcryptography.model.Alias
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.UpdateAliasResponse = {
    import UpdateAliasResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.UpdateAliasResponse
      .builder()
      .alias(alias.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.UpdateAliasResponse.ReadOnly =
    zio.aws.paymentcryptography.model.UpdateAliasResponse.wrap(buildAwsValue())
}
object UpdateAliasResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.UpdateAliasResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.UpdateAliasResponse =
      zio.aws.paymentcryptography.model.UpdateAliasResponse(alias.asEditable)
    def alias: zio.aws.paymentcryptography.model.Alias.ReadOnly
    def getAlias
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.Alias.ReadOnly] =
      ZIO.succeed(alias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.UpdateAliasResponse
  ) extends zio.aws.paymentcryptography.model.UpdateAliasResponse.ReadOnly {
    override val alias: zio.aws.paymentcryptography.model.Alias.ReadOnly =
      zio.aws.paymentcryptography.model.Alias.wrap(impl.alias())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.UpdateAliasResponse
  ): zio.aws.paymentcryptography.model.UpdateAliasResponse.ReadOnly =
    new Wrapper(impl)
}
