package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartKeyUsageResponse(
    key: zio.aws.paymentcryptography.model.Key
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.StartKeyUsageResponse = {
    import StartKeyUsageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.StartKeyUsageResponse
      .builder()
      .key(key.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.StartKeyUsageResponse.ReadOnly =
    zio.aws.paymentcryptography.model.StartKeyUsageResponse
      .wrap(buildAwsValue())
}
object StartKeyUsageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.StartKeyUsageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.StartKeyUsageResponse =
      zio.aws.paymentcryptography.model.StartKeyUsageResponse(key.asEditable)
    def key: zio.aws.paymentcryptography.model.Key.ReadOnly
    def getKey
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.Key.ReadOnly] =
      ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.StartKeyUsageResponse
  ) extends zio.aws.paymentcryptography.model.StartKeyUsageResponse.ReadOnly {
    override val key: zio.aws.paymentcryptography.model.Key.ReadOnly =
      zio.aws.paymentcryptography.model.Key.wrap(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.StartKeyUsageResponse
  ): zio.aws.paymentcryptography.model.StartKeyUsageResponse.ReadOnly =
    new Wrapper(impl)
}
