package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportKeyMaterial(
    rootCertificatePublicKey: Optional[
      zio.aws.paymentcryptography.model.RootCertificatePublicKey
    ] = Optional.Absent,
    tr31KeyBlock: Optional[
      zio.aws.paymentcryptography.model.ImportTr31KeyBlock
    ] = Optional.Absent,
    tr34KeyBlock: Optional[
      zio.aws.paymentcryptography.model.ImportTr34KeyBlock
    ] = Optional.Absent,
    trustedCertificatePublicKey: Optional[
      zio.aws.paymentcryptography.model.TrustedCertificatePublicKey
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ImportKeyMaterial = {
    import ImportKeyMaterial.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ImportKeyMaterial
      .builder()
      .optionallyWith(
        rootCertificatePublicKey.map(value => value.buildAwsValue())
      )(_.rootCertificatePublicKey)
      .optionallyWith(tr31KeyBlock.map(value => value.buildAwsValue()))(
        _.tr31KeyBlock
      )
      .optionallyWith(tr34KeyBlock.map(value => value.buildAwsValue()))(
        _.tr34KeyBlock
      )
      .optionallyWith(
        trustedCertificatePublicKey.map(value => value.buildAwsValue())
      )(_.trustedCertificatePublicKey)
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.ImportKeyMaterial.ReadOnly =
    zio.aws.paymentcryptography.model.ImportKeyMaterial.wrap(buildAwsValue())
}
object ImportKeyMaterial {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ImportKeyMaterial
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.ImportKeyMaterial =
      zio.aws.paymentcryptography.model.ImportKeyMaterial(
        rootCertificatePublicKey.map(value => value.asEditable),
        tr31KeyBlock.map(value => value.asEditable),
        tr34KeyBlock.map(value => value.asEditable),
        trustedCertificatePublicKey.map(value => value.asEditable)
      )
    def rootCertificatePublicKey: Optional[
      zio.aws.paymentcryptography.model.RootCertificatePublicKey.ReadOnly
    ]
    def tr31KeyBlock: Optional[
      zio.aws.paymentcryptography.model.ImportTr31KeyBlock.ReadOnly
    ]
    def tr34KeyBlock: Optional[
      zio.aws.paymentcryptography.model.ImportTr34KeyBlock.ReadOnly
    ]
    def trustedCertificatePublicKey: Optional[
      zio.aws.paymentcryptography.model.TrustedCertificatePublicKey.ReadOnly
    ]
    def getRootCertificatePublicKey: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptography.model.RootCertificatePublicKey.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rootCertificatePublicKey",
      rootCertificatePublicKey
    )
    def getTr31KeyBlock: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptography.model.ImportTr31KeyBlock.ReadOnly
    ] = AwsError.unwrapOptionField("tr31KeyBlock", tr31KeyBlock)
    def getTr34KeyBlock: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptography.model.ImportTr34KeyBlock.ReadOnly
    ] = AwsError.unwrapOptionField("tr34KeyBlock", tr34KeyBlock)
    def getTrustedCertificatePublicKey: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptography.model.TrustedCertificatePublicKey.ReadOnly
    ] = AwsError.unwrapOptionField(
      "trustedCertificatePublicKey",
      trustedCertificatePublicKey
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ImportKeyMaterial
  ) extends zio.aws.paymentcryptography.model.ImportKeyMaterial.ReadOnly {
    override val rootCertificatePublicKey: Optional[
      zio.aws.paymentcryptography.model.RootCertificatePublicKey.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rootCertificatePublicKey())
      .map(value =>
        zio.aws.paymentcryptography.model.RootCertificatePublicKey.wrap(value)
      )
    override val tr31KeyBlock: Optional[
      zio.aws.paymentcryptography.model.ImportTr31KeyBlock.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tr31KeyBlock())
      .map(value =>
        zio.aws.paymentcryptography.model.ImportTr31KeyBlock.wrap(value)
      )
    override val tr34KeyBlock: Optional[
      zio.aws.paymentcryptography.model.ImportTr34KeyBlock.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.tr34KeyBlock())
      .map(value =>
        zio.aws.paymentcryptography.model.ImportTr34KeyBlock.wrap(value)
      )
    override val trustedCertificatePublicKey: Optional[
      zio.aws.paymentcryptography.model.TrustedCertificatePublicKey.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.trustedCertificatePublicKey())
      .map(value =>
        zio.aws.paymentcryptography.model.TrustedCertificatePublicKey
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ImportKeyMaterial
  ): zio.aws.paymentcryptography.model.ImportKeyMaterial.ReadOnly = new Wrapper(
    impl
  )
}
