package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetParametersForImportRequest(
    keyMaterialType: zio.aws.paymentcryptography.model.KeyMaterialType,
    wrappingKeyAlgorithm: zio.aws.paymentcryptography.model.KeyAlgorithm
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.GetParametersForImportRequest = {
    import GetParametersForImportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.GetParametersForImportRequest
      .builder()
      .keyMaterialType(keyMaterialType.unwrap)
      .wrappingKeyAlgorithm(wrappingKeyAlgorithm.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.GetParametersForImportRequest.ReadOnly =
    zio.aws.paymentcryptography.model.GetParametersForImportRequest
      .wrap(buildAwsValue())
}
object GetParametersForImportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.GetParametersForImportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptography.model.GetParametersForImportRequest =
      zio.aws.paymentcryptography.model
        .GetParametersForImportRequest(keyMaterialType, wrappingKeyAlgorithm)
    def keyMaterialType: zio.aws.paymentcryptography.model.KeyMaterialType
    def wrappingKeyAlgorithm: zio.aws.paymentcryptography.model.KeyAlgorithm
    def getKeyMaterialType
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.KeyMaterialType] =
      ZIO.succeed(keyMaterialType)
    def getWrappingKeyAlgorithm
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.KeyAlgorithm] =
      ZIO.succeed(wrappingKeyAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetParametersForImportRequest
  ) extends zio.aws.paymentcryptography.model.GetParametersForImportRequest.ReadOnly {
    override val keyMaterialType
        : zio.aws.paymentcryptography.model.KeyMaterialType =
      zio.aws.paymentcryptography.model.KeyMaterialType
        .wrap(impl.keyMaterialType())
    override val wrappingKeyAlgorithm
        : zio.aws.paymentcryptography.model.KeyAlgorithm =
      zio.aws.paymentcryptography.model.KeyAlgorithm
        .wrap(impl.wrappingKeyAlgorithm())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetParametersForImportRequest
  ): zio.aws.paymentcryptography.model.GetParametersForImportRequest.ReadOnly =
    new Wrapper(impl)
}
