package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateKeyRequest(
    enabled: Optional[Boolean] = Optional.Absent,
    exportable: Boolean,
    keyAttributes: zio.aws.paymentcryptography.model.KeyAttributes,
    keyCheckValueAlgorithm: Optional[
      zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.paymentcryptography.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.CreateKeyRequest = {
    import CreateKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.CreateKeyRequest
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .exportable(exportable: java.lang.Boolean)
      .keyAttributes(keyAttributes.buildAwsValue())
      .optionallyWith(keyCheckValueAlgorithm.map(value => value.unwrap))(
        _.keyCheckValueAlgorithm
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.CreateKeyRequest.ReadOnly =
    zio.aws.paymentcryptography.model.CreateKeyRequest.wrap(buildAwsValue())
}
object CreateKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.CreateKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.CreateKeyRequest =
      zio.aws.paymentcryptography.model.CreateKeyRequest(
        enabled.map(value => value),
        exportable,
        keyAttributes.asEditable,
        keyCheckValueAlgorithm.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def enabled: Optional[Boolean]
    def exportable: Boolean
    def keyAttributes: zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly
    def keyCheckValueAlgorithm
        : Optional[zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm]
    def tags: Optional[List[zio.aws.paymentcryptography.model.Tag.ReadOnly]]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getExportable: ZIO[Any, Nothing, Boolean] = ZIO.succeed(exportable)
    def getKeyAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly
    ] = ZIO.succeed(keyAttributes)
    def getKeyCheckValueAlgorithm: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm
    ] = AwsError.unwrapOptionField(
      "keyCheckValueAlgorithm",
      keyCheckValueAlgorithm
    )
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.paymentcryptography.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.CreateKeyRequest
  ) extends zio.aws.paymentcryptography.model.CreateKeyRequest.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val exportable: Boolean = impl.exportable(): Boolean
    override val keyAttributes
        : zio.aws.paymentcryptography.model.KeyAttributes.ReadOnly =
      zio.aws.paymentcryptography.model.KeyAttributes.wrap(impl.keyAttributes())
    override val keyCheckValueAlgorithm
        : Optional[zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyCheckValueAlgorithm())
        .map(value =>
          zio.aws.paymentcryptography.model.KeyCheckValueAlgorithm.wrap(value)
        )
    override val tags
        : Optional[List[zio.aws.paymentcryptography.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.paymentcryptography.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.CreateKeyRequest
  ): zio.aws.paymentcryptography.model.CreateKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
