package zio.aws.paymentcryptography
import zio.aws.paymentcryptography.model.ListKeysResponse.ReadOnly
import zio.aws.paymentcryptography.model.{
  GetParametersForImportRequest,
  UpdateAliasRequest,
  GetKeyRequest,
  CreateKeyRequest,
  CreateAliasRequest,
  ListTagsForResourceRequest,
  DeleteAliasRequest,
  ListAliasesRequest,
  DeleteKeyRequest,
  RestoreKeyRequest,
  ImportKeyRequest,
  GetPublicKeyCertificateRequest,
  UntagResourceRequest,
  StopKeyUsageRequest,
  StartKeyUsageRequest,
  ListKeysRequest,
  ExportKeyRequest,
  TagResourceRequest,
  GetAliasRequest,
  GetParametersForExportRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.paymentcryptography.PaymentCryptographyAsyncClient
object PaymentCryptographyMock extends Mock[PaymentCryptography] {
  object GetKey
      extends Effect[
        GetKeyRequest,
        AwsError,
        zio.aws.paymentcryptography.model.GetKeyResponse.ReadOnly
      ]
  object ExportKey
      extends Effect[
        ExportKeyRequest,
        AwsError,
        zio.aws.paymentcryptography.model.ExportKeyResponse.ReadOnly
      ]
  object DeleteKey
      extends Effect[
        DeleteKeyRequest,
        AwsError,
        zio.aws.paymentcryptography.model.DeleteKeyResponse.ReadOnly
      ]
  object GetParametersForExport
      extends Effect[
        GetParametersForExportRequest,
        AwsError,
        zio.aws.paymentcryptography.model.GetParametersForExportResponse.ReadOnly
      ]
  object StopKeyUsage
      extends Effect[
        StopKeyUsageRequest,
        AwsError,
        zio.aws.paymentcryptography.model.StopKeyUsageResponse.ReadOnly
      ]
  object ListAliases
      extends Stream[
        ListAliasesRequest,
        AwsError,
        zio.aws.paymentcryptography.model.Alias.ReadOnly
      ]
  object ListAliasesPaginated
      extends Effect[
        ListAliasesRequest,
        AwsError,
        zio.aws.paymentcryptography.model.ListAliasesResponse.ReadOnly
      ]
  object GetParametersForImport
      extends Effect[
        GetParametersForImportRequest,
        AwsError,
        zio.aws.paymentcryptography.model.GetParametersForImportResponse.ReadOnly
      ]
  object RestoreKey
      extends Effect[
        RestoreKeyRequest,
        AwsError,
        zio.aws.paymentcryptography.model.RestoreKeyResponse.ReadOnly
      ]
  object UpdateAlias
      extends Effect[
        UpdateAliasRequest,
        AwsError,
        zio.aws.paymentcryptography.model.UpdateAliasResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.paymentcryptography.model.UntagResourceResponse.ReadOnly
      ]
  object CreateAlias
      extends Effect[
        CreateAliasRequest,
        AwsError,
        zio.aws.paymentcryptography.model.CreateAliasResponse.ReadOnly
      ]
  object GetPublicKeyCertificate
      extends Effect[
        GetPublicKeyCertificateRequest,
        AwsError,
        zio.aws.paymentcryptography.model.GetPublicKeyCertificateResponse.ReadOnly
      ]
  object CreateKey
      extends Effect[
        CreateKeyRequest,
        AwsError,
        zio.aws.paymentcryptography.model.CreateKeyResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.paymentcryptography.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.paymentcryptography.model.ListTagsForResourceResponse.ReadOnly
      ]
  object StartKeyUsage
      extends Effect[
        StartKeyUsageRequest,
        AwsError,
        zio.aws.paymentcryptography.model.StartKeyUsageResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.paymentcryptography.model.TagResourceResponse.ReadOnly
      ]
  object ImportKey
      extends Effect[
        ImportKeyRequest,
        AwsError,
        zio.aws.paymentcryptography.model.ImportKeyResponse.ReadOnly
      ]
  object DeleteAlias
      extends Effect[
        DeleteAliasRequest,
        AwsError,
        zio.aws.paymentcryptography.model.DeleteAliasResponse.ReadOnly
      ]
  object GetAlias
      extends Effect[
        GetAliasRequest,
        AwsError,
        zio.aws.paymentcryptography.model.GetAliasResponse.ReadOnly
      ]
  object ListKeys
      extends Stream[
        ListKeysRequest,
        AwsError,
        zio.aws.paymentcryptography.model.KeySummary.ReadOnly
      ]
  object ListKeysPaginated extends Effect[ListKeysRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, PaymentCryptography] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, PaymentCryptography] { rts =>
        zio.ZIO.succeed {
          new PaymentCryptography {
            val api: PaymentCryptographyAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): PaymentCryptography = this
            def getKey(request: GetKeyRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.GetKeyResponse.ReadOnly
            ] = proxy(GetKey, request)
            def exportKey(request: ExportKeyRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.ExportKeyResponse.ReadOnly
            ] = proxy(ExportKey, request)
            def deleteKey(request: DeleteKeyRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.DeleteKeyResponse.ReadOnly
            ] = proxy(DeleteKey, request)
            def getParametersForExport(
                request: GetParametersForExportRequest
            ): IO[
              AwsError,
              zio.aws.paymentcryptography.model.GetParametersForExportResponse.ReadOnly
            ] = proxy(GetParametersForExport, request)
            def stopKeyUsage(request: StopKeyUsageRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.StopKeyUsageResponse.ReadOnly
            ] = proxy(StopKeyUsage, request)
            def listAliases(request: ListAliasesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.paymentcryptography.model.Alias.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAliases, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAliasesPaginated(request: ListAliasesRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.ListAliasesResponse.ReadOnly
            ] = proxy(ListAliasesPaginated, request)
            def getParametersForImport(
                request: GetParametersForImportRequest
            ): IO[
              AwsError,
              zio.aws.paymentcryptography.model.GetParametersForImportResponse.ReadOnly
            ] = proxy(GetParametersForImport, request)
            def restoreKey(request: RestoreKeyRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.RestoreKeyResponse.ReadOnly
            ] = proxy(RestoreKey, request)
            def updateAlias(request: UpdateAliasRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.UpdateAliasResponse.ReadOnly
            ] = proxy(UpdateAlias, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createAlias(request: CreateAliasRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.CreateAliasResponse.ReadOnly
            ] = proxy(CreateAlias, request)
            def getPublicKeyCertificate(
                request: GetPublicKeyCertificateRequest
            ): IO[
              AwsError,
              zio.aws.paymentcryptography.model.GetPublicKeyCertificateResponse.ReadOnly
            ] = proxy(GetPublicKeyCertificate, request)
            def createKey(request: CreateKeyRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.CreateKeyResponse.ReadOnly
            ] = proxy(CreateKey, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.paymentcryptography.model.Tag.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTagsForResource, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.paymentcryptography.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def startKeyUsage(request: StartKeyUsageRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.StartKeyUsageResponse.ReadOnly
            ] = proxy(StartKeyUsage, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def importKey(request: ImportKeyRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.ImportKeyResponse.ReadOnly
            ] = proxy(ImportKey, request)
            def deleteAlias(request: DeleteAliasRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.DeleteAliasResponse.ReadOnly
            ] = proxy(DeleteAlias, request)
            def getAlias(request: GetAliasRequest): IO[
              AwsError,
              zio.aws.paymentcryptography.model.GetAliasResponse.ReadOnly
            ] = proxy(GetAlias, request)
            def listKeys(request: ListKeysRequest): ZStream[
              Any,
              AwsError,
              zio.aws.paymentcryptography.model.KeySummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListKeys, request)
                }
                .getOrThrowFiberFailure()
            }
            def listKeysPaginated(
                request: ListKeysRequest
            ): IO[AwsError, ReadOnly] = proxy(ListKeysPaginated, request)
          }
        }
      }
    }
  }
}
