package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListKeysResponse(
    keys: Iterable[zio.aws.paymentcryptography.model.KeySummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ListKeysResponse = {
    import ListKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ListKeysResponse
      .builder()
      .keys(keys.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.ListKeysResponse.ReadOnly =
    zio.aws.paymentcryptography.model.ListKeysResponse.wrap(buildAwsValue())
}
object ListKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ListKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.ListKeysResponse =
      zio.aws.paymentcryptography.model.ListKeysResponse(
        keys.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def keys: List[zio.aws.paymentcryptography.model.KeySummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getKeys: ZIO[Any, Nothing, List[
      zio.aws.paymentcryptography.model.KeySummary.ReadOnly
    ]] = ZIO.succeed(keys)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ListKeysResponse
  ) extends zio.aws.paymentcryptography.model.ListKeysResponse.ReadOnly {
    override val keys
        : List[zio.aws.paymentcryptography.model.KeySummary.ReadOnly] = impl
      .keys()
      .asScala
      .map { item =>
        zio.aws.paymentcryptography.model.KeySummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ListKeysResponse
  ): zio.aws.paymentcryptography.model.ListKeysResponse.ReadOnly = new Wrapper(
    impl
  )
}
