package zio.aws.paymentcryptography.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.paymentcryptography.model.primitives.{
  KeyArnOrKeyAliasType,
  DeleteKeyInputDeleteKeyInDaysInteger
}
import scala.jdk.CollectionConverters._
final case class DeleteKeyRequest(
    deleteKeyInDays: Optional[DeleteKeyInputDeleteKeyInDaysInteger] =
      Optional.Absent,
    keyIdentifier: KeyArnOrKeyAliasType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.DeleteKeyRequest = {
    import DeleteKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.DeleteKeyRequest
      .builder()
      .optionallyWith(
        deleteKeyInDays.map(value =>
          DeleteKeyInputDeleteKeyInDaysInteger.unwrap(value): Integer
        )
      )(_.deleteKeyInDays)
      .keyIdentifier(
        KeyArnOrKeyAliasType.unwrap(keyIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.DeleteKeyRequest.ReadOnly =
    zio.aws.paymentcryptography.model.DeleteKeyRequest.wrap(buildAwsValue())
}
object DeleteKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.DeleteKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.DeleteKeyRequest =
      zio.aws.paymentcryptography.model
        .DeleteKeyRequest(deleteKeyInDays.map(value => value), keyIdentifier)
    def deleteKeyInDays: Optional[DeleteKeyInputDeleteKeyInDaysInteger]
    def keyIdentifier: KeyArnOrKeyAliasType
    def getDeleteKeyInDays
        : ZIO[Any, AwsError, DeleteKeyInputDeleteKeyInDaysInteger] =
      AwsError.unwrapOptionField("deleteKeyInDays", deleteKeyInDays)
    def getKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(keyIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.DeleteKeyRequest
  ) extends zio.aws.paymentcryptography.model.DeleteKeyRequest.ReadOnly {
    override val deleteKeyInDays
        : Optional[DeleteKeyInputDeleteKeyInDaysInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteKeyInDays())
      .map(value =>
        zio.aws.paymentcryptography.model.primitives
          .DeleteKeyInputDeleteKeyInDaysInteger(value)
      )
    override val keyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptography.model.primitives
        .KeyArnOrKeyAliasType(impl.keyIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.DeleteKeyRequest
  ): zio.aws.paymentcryptography.model.DeleteKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
