package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.KeyArnOrKeyAliasType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StopKeyUsageRequest(keyIdentifier: KeyArnOrKeyAliasType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.StopKeyUsageRequest = {
    import StopKeyUsageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.StopKeyUsageRequest
      .builder()
      .keyIdentifier(
        KeyArnOrKeyAliasType.unwrap(keyIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.StopKeyUsageRequest.ReadOnly =
    zio.aws.paymentcryptography.model.StopKeyUsageRequest.wrap(buildAwsValue())
}
object StopKeyUsageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.StopKeyUsageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.StopKeyUsageRequest =
      zio.aws.paymentcryptography.model.StopKeyUsageRequest(keyIdentifier)
    def keyIdentifier: KeyArnOrKeyAliasType
    def getKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(keyIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.StopKeyUsageRequest
  ) extends zio.aws.paymentcryptography.model.StopKeyUsageRequest.ReadOnly {
    override val keyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptography.model.primitives
        .KeyArnOrKeyAliasType(impl.keyIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.StopKeyUsageRequest
  ): zio.aws.paymentcryptography.model.StopKeyUsageRequest.ReadOnly =
    new Wrapper(impl)
}
