package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetParametersForExportRequest(
    keyMaterialType: zio.aws.paymentcryptography.model.KeyMaterialType,
    signingKeyAlgorithm: zio.aws.paymentcryptography.model.KeyAlgorithm
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.GetParametersForExportRequest = {
    import GetParametersForExportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.GetParametersForExportRequest
      .builder()
      .keyMaterialType(keyMaterialType.unwrap)
      .signingKeyAlgorithm(signingKeyAlgorithm.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.paymentcryptography.model.GetParametersForExportRequest.ReadOnly =
    zio.aws.paymentcryptography.model.GetParametersForExportRequest
      .wrap(buildAwsValue())
}
object GetParametersForExportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.GetParametersForExportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.paymentcryptography.model.GetParametersForExportRequest =
      zio.aws.paymentcryptography.model
        .GetParametersForExportRequest(keyMaterialType, signingKeyAlgorithm)
    def keyMaterialType: zio.aws.paymentcryptography.model.KeyMaterialType
    def signingKeyAlgorithm: zio.aws.paymentcryptography.model.KeyAlgorithm
    def getKeyMaterialType
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.KeyMaterialType] =
      ZIO.succeed(keyMaterialType)
    def getSigningKeyAlgorithm
        : ZIO[Any, Nothing, zio.aws.paymentcryptography.model.KeyAlgorithm] =
      ZIO.succeed(signingKeyAlgorithm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetParametersForExportRequest
  ) extends zio.aws.paymentcryptography.model.GetParametersForExportRequest.ReadOnly {
    override val keyMaterialType
        : zio.aws.paymentcryptography.model.KeyMaterialType =
      zio.aws.paymentcryptography.model.KeyMaterialType
        .wrap(impl.keyMaterialType())
    override val signingKeyAlgorithm
        : zio.aws.paymentcryptography.model.KeyAlgorithm =
      zio.aws.paymentcryptography.model.KeyAlgorithm
        .wrap(impl.signingKeyAlgorithm())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetParametersForExportRequest
  ): zio.aws.paymentcryptography.model.GetParametersForExportRequest.ReadOnly =
    new Wrapper(impl)
}
