package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.AliasName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAliasRequest(aliasName: AliasName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.GetAliasRequest = {
    import GetAliasRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.GetAliasRequest
      .builder()
      .aliasName(AliasName.unwrap(aliasName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.GetAliasRequest.ReadOnly =
    zio.aws.paymentcryptography.model.GetAliasRequest.wrap(buildAwsValue())
}
object GetAliasRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.GetAliasRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.GetAliasRequest =
      zio.aws.paymentcryptography.model.GetAliasRequest(aliasName)
    def aliasName: AliasName
    def getAliasName: ZIO[Any, Nothing, AliasName] = ZIO.succeed(aliasName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetAliasRequest
  ) extends zio.aws.paymentcryptography.model.GetAliasRequest.ReadOnly {
    override val aliasName: AliasName =
      zio.aws.paymentcryptography.model.primitives.AliasName(impl.aliasName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.GetAliasRequest
  ): zio.aws.paymentcryptography.model.GetAliasRequest.ReadOnly = new Wrapper(
    impl
  )
}
