package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.{KeyArn, KeyMaterial}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class WrappedKey(
    keyMaterial: KeyMaterial,
    wrappedKeyMaterialFormat: zio.aws.paymentcryptography.model.WrappedKeyMaterialFormat,
    wrappingKeyArn: KeyArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.WrappedKey = {
    import WrappedKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.WrappedKey
      .builder()
      .keyMaterial(KeyMaterial.unwrap(keyMaterial): java.lang.String)
      .wrappedKeyMaterialFormat(wrappedKeyMaterialFormat.unwrap)
      .wrappingKeyArn(KeyArn.unwrap(wrappingKeyArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.WrappedKey.ReadOnly =
    zio.aws.paymentcryptography.model.WrappedKey.wrap(buildAwsValue())
}
object WrappedKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.WrappedKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.WrappedKey =
      zio.aws.paymentcryptography.model
        .WrappedKey(keyMaterial, wrappedKeyMaterialFormat, wrappingKeyArn)
    def keyMaterial: KeyMaterial
    def wrappedKeyMaterialFormat
        : zio.aws.paymentcryptography.model.WrappedKeyMaterialFormat
    def wrappingKeyArn: KeyArn
    def getKeyMaterial: ZIO[Any, Nothing, KeyMaterial] =
      ZIO.succeed(keyMaterial)
    def getWrappedKeyMaterialFormat: ZIO[
      Any,
      Nothing,
      zio.aws.paymentcryptography.model.WrappedKeyMaterialFormat
    ] = ZIO.succeed(wrappedKeyMaterialFormat)
    def getWrappingKeyArn: ZIO[Any, Nothing, KeyArn] =
      ZIO.succeed(wrappingKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.WrappedKey
  ) extends zio.aws.paymentcryptography.model.WrappedKey.ReadOnly {
    override val keyMaterial: KeyMaterial =
      zio.aws.paymentcryptography.model.primitives
        .KeyMaterial(impl.keyMaterial())
    override val wrappedKeyMaterialFormat
        : zio.aws.paymentcryptography.model.WrappedKeyMaterialFormat =
      zio.aws.paymentcryptography.model.WrappedKeyMaterialFormat
        .wrap(impl.wrappedKeyMaterialFormat())
    override val wrappingKeyArn: KeyArn =
      zio.aws.paymentcryptography.model.primitives.KeyArn(impl.wrappingKeyArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.WrappedKey
  ): zio.aws.paymentcryptography.model.WrappedKey.ReadOnly = new Wrapper(impl)
}
