package zio.aws.paymentcryptography.model
import zio.aws.paymentcryptography.model.primitives.KeyArnOrKeyAliasType
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RestoreKeyRequest(keyIdentifier: KeyArnOrKeyAliasType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.RestoreKeyRequest = {
    import RestoreKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.RestoreKeyRequest
      .builder()
      .keyIdentifier(
        KeyArnOrKeyAliasType.unwrap(keyIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.RestoreKeyRequest.ReadOnly =
    zio.aws.paymentcryptography.model.RestoreKeyRequest.wrap(buildAwsValue())
}
object RestoreKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.RestoreKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.RestoreKeyRequest =
      zio.aws.paymentcryptography.model.RestoreKeyRequest(keyIdentifier)
    def keyIdentifier: KeyArnOrKeyAliasType
    def getKeyIdentifier: ZIO[Any, Nothing, KeyArnOrKeyAliasType] =
      ZIO.succeed(keyIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.RestoreKeyRequest
  ) extends zio.aws.paymentcryptography.model.RestoreKeyRequest.ReadOnly {
    override val keyIdentifier: KeyArnOrKeyAliasType =
      zio.aws.paymentcryptography.model.primitives
        .KeyArnOrKeyAliasType(impl.keyIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.RestoreKeyRequest
  ): zio.aws.paymentcryptography.model.RestoreKeyRequest.ReadOnly = new Wrapper(
    impl
  )
}
