package zio.aws.paymentcryptography.model
import scala.jdk.CollectionConverters._
sealed trait KeyAlgorithm {
  def unwrap
      : software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm
}
object KeyAlgorithm {
  def wrap(
      value: software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm
  ): zio.aws.paymentcryptography.model.KeyAlgorithm = value match {
    case software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.TDES_2_KEY =>
      val r = TDES_2KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.TDES_3_KEY =>
      val r = TDES_3KEY
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.AES_128 =>
      val r = AES_128
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.AES_192 =>
      val r = AES_192
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.AES_256 =>
      val r = AES_256
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.RSA_2048 =>
      val r = RSA_2048
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.RSA_3072 =>
      val r = RSA_3072
      r
    case software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.RSA_4096 =>
      val r = RSA_4096
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.paymentcryptography.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm =
      software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.UNKNOWN_TO_SDK_VERSION
  }
  case object TDES_2KEY extends zio.aws.paymentcryptography.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm =
      software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.TDES_2_KEY
  }
  case object TDES_3KEY extends zio.aws.paymentcryptography.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm =
      software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.TDES_3_KEY
  }
  case object AES_128 extends zio.aws.paymentcryptography.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm =
      software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.AES_128
  }
  case object AES_192 extends zio.aws.paymentcryptography.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm =
      software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.AES_192
  }
  case object AES_256 extends zio.aws.paymentcryptography.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm =
      software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.AES_256
  }
  case object RSA_2048 extends zio.aws.paymentcryptography.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm =
      software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.RSA_2048
  }
  case object RSA_3072 extends zio.aws.paymentcryptography.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm =
      software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.RSA_3072
  }
  case object RSA_4096 extends zio.aws.paymentcryptography.model.KeyAlgorithm {
    override def unwrap
        : software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm =
      software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm.RSA_4096
  }
}
