package zio.aws.paymentcryptography.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExportKeyResponse(
    wrappedKey: Optional[zio.aws.paymentcryptography.model.WrappedKey] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.paymentcryptography.model.ExportKeyResponse = {
    import ExportKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.paymentcryptography.model.ExportKeyResponse
      .builder()
      .optionallyWith(wrappedKey.map(value => value.buildAwsValue()))(
        _.wrappedKey
      )
      .build()
  }
  def asReadOnly: zio.aws.paymentcryptography.model.ExportKeyResponse.ReadOnly =
    zio.aws.paymentcryptography.model.ExportKeyResponse.wrap(buildAwsValue())
}
object ExportKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.paymentcryptography.model.ExportKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.paymentcryptography.model.ExportKeyResponse =
      zio.aws.paymentcryptography.model
        .ExportKeyResponse(wrappedKey.map(value => value.asEditable))
    def wrappedKey
        : Optional[zio.aws.paymentcryptography.model.WrappedKey.ReadOnly]
    def getWrappedKey: ZIO[
      Any,
      AwsError,
      zio.aws.paymentcryptography.model.WrappedKey.ReadOnly
    ] = AwsError.unwrapOptionField("wrappedKey", wrappedKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ExportKeyResponse
  ) extends zio.aws.paymentcryptography.model.ExportKeyResponse.ReadOnly {
    override val wrappedKey
        : Optional[zio.aws.paymentcryptography.model.WrappedKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.wrappedKey())
        .map(value => zio.aws.paymentcryptography.model.WrappedKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.paymentcryptography.model.ExportKeyResponse
  ): zio.aws.paymentcryptography.model.ExportKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
